/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.parser;

import java.util.List;
import javax.xml.stream.XMLStreamReader;
import org.flowable.bpmn.constants.BpmnXMLConstants;
import org.flowable.bpmn.converter.child.ElementNameParser;
import org.flowable.bpmn.converter.child.ExecutionListenerParser;
import org.flowable.bpmn.converter.child.FlowableEventListenerParser;
import org.flowable.bpmn.converter.parser.PotentialStarterParser;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SubProcess;

public class ExtensionElementsParser
implements BpmnXMLConstants {
    public void parse(XMLStreamReader xtr, List<SubProcess> activeSubProcessList, Process activeProcess, BpmnModel model) throws Exception {
        Object parentElement = null;
        parentElement = !activeSubProcessList.isEmpty() ? (BaseElement)activeSubProcessList.get(activeSubProcessList.size() - 1) : activeProcess;
        boolean readyWithChildElements = false;
        while (!readyWithChildElements && xtr.hasNext()) {
            xtr.next();
            if (xtr.isStartElement()) {
                if ("executionListener".equals(xtr.getLocalName())) {
                    new ExecutionListenerParser().parseChildElement(xtr, (BaseElement)parentElement, model);
                    continue;
                }
                if ("eventListener".equals(xtr.getLocalName())) {
                    new FlowableEventListenerParser().parseChildElement(xtr, (BaseElement)parentElement, model);
                    continue;
                }
                if ("potentialStarter".equals(xtr.getLocalName())) {
                    new PotentialStarterParser().parse(xtr, activeProcess);
                    continue;
                }
                if ("element-name".equals(xtr.getLocalName())) {
                    new ElementNameParser().parseChildElement(xtr, (BaseElement)parentElement, model);
                    continue;
                }
                ExtensionElement extensionElement = BpmnXMLUtil.parseExtensionElement(xtr);
                parentElement.addExtensionElement(extensionElement);
                continue;
            }
            if (!xtr.isEndElement() || !"extensionElements".equals(xtr.getLocalName())) continue;
            readyWithChildElements = true;
        }
    }
}

