/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.export;

import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.constants.BpmnXMLConstants;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.Lane;
import org.flowable.bpmn.model.Process;

public class LaneExport
implements BpmnXMLConstants {
    public static void writeLanes(Process process, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        if (!process.getLanes().isEmpty()) {
            xtw.writeStartElement("laneSet");
            xtw.writeAttribute("id", "laneSet_" + process.getId());
            for (Lane lane : process.getLanes()) {
                boolean didWriteExtensionStartElement;
                xtw.writeStartElement("lane");
                xtw.writeAttribute("id", lane.getId());
                if (StringUtils.isNotEmpty((CharSequence)lane.getName())) {
                    xtw.writeAttribute("name", lane.getName());
                }
                if (didWriteExtensionStartElement = BpmnXMLUtil.writeExtensionElements((BaseElement)lane, false, model.getNamespaces(), xtw)) {
                    xtw.writeEndElement();
                }
                for (String flowNodeRef : lane.getFlowReferences()) {
                    xtw.writeStartElement("flowNodeRef");
                    xtw.writeCharacters(flowNodeRef);
                    xtw.writeEndElement();
                }
                xtw.writeEndElement();
            }
            xtw.writeEndElement();
        }
    }
}

