/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.batch.service.impl;

import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchBuilder;
import org.flowable.batch.service.BatchServiceConfiguration;
import org.flowable.batch.service.impl.BatchServiceImpl;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;

public class BatchBuilderImpl
implements BatchBuilder {
    protected BatchServiceConfiguration batchServiceConfiguration;
    protected CommandExecutor commandExecutor;
    protected String batchType;
    protected String searchKey;
    protected String searchKey2;
    protected String status;
    protected String batchDocumentJson;
    protected String tenantId;

    public BatchBuilderImpl() {
    }

    public BatchBuilderImpl(CommandExecutor commandExecutor, BatchServiceConfiguration batchServiceConfiguration) {
        this.commandExecutor = commandExecutor;
        this.batchServiceConfiguration = batchServiceConfiguration;
    }

    public BatchBuilderImpl(BatchServiceConfiguration batchServiceConfiguration) {
        this.batchServiceConfiguration = batchServiceConfiguration;
    }

    public BatchBuilder batchType(String batchType) {
        this.batchType = batchType;
        return this;
    }

    public BatchBuilder searchKey(String searchKey) {
        this.searchKey = searchKey;
        return this;
    }

    public BatchBuilder searchKey2(String searchKey2) {
        this.searchKey2 = searchKey2;
        return this;
    }

    public BatchBuilder status(String status) {
        this.status = status;
        return this;
    }

    public BatchBuilder batchDocumentJson(String batchDocumentJson) {
        this.batchDocumentJson = batchDocumentJson;
        return this;
    }

    public BatchBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public Batch create() {
        if (this.commandExecutor != null) {
            final BatchBuilderImpl selfBatchBuilder = this;
            return (Batch)this.commandExecutor.execute((Command)new Command<Batch>(){

                public Batch execute(CommandContext commandContext) {
                    return BatchBuilderImpl.this.batchServiceConfiguration.getBatchEntityManager().createBatch(selfBatchBuilder);
                }
            });
        }
        return ((BatchServiceImpl)this.batchServiceConfiguration.getBatchService()).createBatch(this);
    }

    public String getBatchType() {
        return this.batchType;
    }

    public String getSearchKey() {
        return this.searchKey;
    }

    public String getSearchKey2() {
        return this.searchKey2;
    }

    public String getStatus() {
        return this.status;
    }

    public String getBatchDocumentJson() {
        return this.batchDocumentJson;
    }

    public String getTenantId() {
        return this.tenantId;
    }
}

