/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.fakereplace.ConstructorArgument;
import org.fakereplace.data.ClassData;
import org.fakereplace.data.ClassDataStore;
import org.fakereplace.data.MemberType;
import org.fakereplace.data.MethodData;
import org.fakereplace.javassist.bytecode.AccessFlag;
import org.fakereplace.javassist.bytecode.Descriptor;
import org.fakereplace.util.DescriptorUtils;
import sun.reflect.Reflection;

public class ConstructorReflection {
    public static Object newInstance(Constructor<?> method, Object ... args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException {
        MethodData data = ClassDataStore.instance().getMethodInformation(method.getDeclaringClass().getName());
        Class<?> info = ClassDataStore.instance().getRealClassFromProxyName(method.getDeclaringClass().getName());
        try {
            Constructor<?> invoke = info.getConstructor(Integer.TYPE, Object[].class, ConstructorArgument.class);
            Object[] ar = args;
            if (ar == null) {
                ar = new Object[]{};
            }
            if (!Modifier.isPublic(method.getModifiers()) && !method.isAccessible()) {
                Class caller = Reflection.getCallerClass((int)2);
                Reflection.ensureMemberAccess((Class)caller, method.getDeclaringClass(), null, (int)method.getModifiers());
            }
            return invoke.newInstance(data.getMethodNo(), ar, null);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static Constructor<?>[] getDeclaredConstructors(Class<?> clazz) {
        try {
            ClassData cd = ClassDataStore.instance().getModifiedClassData(clazz.getClassLoader(), Descriptor.toJvmName(clazz.getName()));
            if (cd == null || !cd.isReplaceable()) {
                return clazz.getDeclaredConstructors();
            }
            Constructor<?>[] meth = clazz.getDeclaredConstructors();
            ArrayList visible = new ArrayList(meth.length);
            for (int i = 0; i < meth.length; ++i) {
                if (meth[i].getParameterTypes().length == 3 && meth[i].getParameterTypes()[2].equals(ConstructorArgument.class)) continue;
                visible.add(meth[i]);
            }
            for (MethodData i : cd.getMethods()) {
                Class<?> c;
                if (i.getType() == MemberType.FAKE_CONSTRUCTOR) {
                    c = clazz.getClassLoader().loadClass(i.getClassName());
                    visible.add(i.getConstructor(c));
                    continue;
                }
                if (i.getType() != MemberType.REMOVED) continue;
                c = clazz.getClassLoader().loadClass(i.getClassName());
                visible.remove(i.getConstructor(c));
            }
            Constructor[] ret = new Constructor[visible.size()];
            for (int i = 0; i < visible.size(); ++i) {
                ret[i] = (Constructor)visible.get(i);
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Constructor<?>[] getConstructors(Class<?> clazz) {
        try {
            ClassData cd = ClassDataStore.instance().getModifiedClassData(clazz.getClassLoader(), Descriptor.toJvmName(clazz.getName()));
            if (cd == null || !cd.isReplaceable()) {
                return clazz.getConstructors();
            }
            Constructor<?>[] meth = clazz.getConstructors();
            ArrayList visible = new ArrayList(meth.length);
            for (int i = 0; i < meth.length; ++i) {
                if (meth[i].getParameterTypes().length == 3 && meth[i].getParameterTypes()[2].equals(ConstructorArgument.class)) continue;
                visible.add(meth[i]);
            }
            for (ClassData cta = cd; cta != null; cta = cta.getSuperClassInformation()) {
                for (MethodData i : cta.getMethods()) {
                    Class<?> c;
                    if (i.getType() == MemberType.FAKE_CONSTRUCTOR && AccessFlag.isPublic(i.getAccessFlags())) {
                        c = clazz.getClassLoader().loadClass(i.getClassName());
                        visible.add(i.getConstructor(c));
                        continue;
                    }
                    if (i.getType() != MemberType.REMOVED) continue;
                    c = clazz.getClassLoader().loadClass(i.getClassName());
                    visible.remove(i.getConstructor(c));
                }
            }
            Constructor[] ret = new Constructor[visible.size()];
            for (int i = 0; i < visible.size(); ++i) {
                ret[i] = (Constructor)visible.get(i);
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... parameters) throws NoSuchMethodException {
        ClassData cd = ClassDataStore.instance().getModifiedClassData(clazz.getClassLoader(), Descriptor.toJvmName(clazz.getName()));
        if (cd == null || !cd.isReplaceable()) {
            Constructor<?> meth = clazz.getConstructor(parameters);
            return meth;
        }
        String args = '(' + DescriptorUtils.classArrayToDescriptorString(parameters) + ')';
        MethodData md = cd.getMethodData("<init>", args);
        if (md == null) {
            Constructor<?> meth = clazz.getConstructor(parameters);
            return meth;
        }
        switch (md.getType()) {
            case NORMAL: {
                Constructor<?> meth = clazz.getConstructor(parameters);
                return meth;
            }
            case FAKE_CONSTRUCTOR: {
                try {
                    Class<?> c = clazz.getClassLoader().loadClass(md.getClassName());
                    Constructor<?> meth = c.getConstructor(parameters);
                    return meth;
                }
                catch (NoSuchMethodException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        throw new NoSuchMethodException();
    }

    public static Constructor<?> getDeclaredConstructor(Class<?> clazz, Class<?> ... parameters) throws NoSuchMethodException {
        ClassData cd = ClassDataStore.instance().getModifiedClassData(clazz.getClassLoader(), Descriptor.toJvmName(clazz.getName()));
        if (cd == null || !cd.isReplaceable()) {
            Constructor<?> meth = clazz.getDeclaredConstructor(parameters);
            return meth;
        }
        String args = '(' + DescriptorUtils.classArrayToDescriptorString(parameters) + ')';
        MethodData md = cd.getMethodData("<init>", args);
        if (md == null) {
            Constructor<?> meth = clazz.getDeclaredConstructor(parameters);
            return meth;
        }
        switch (md.getType()) {
            case NORMAL: {
                Constructor<?> meth = clazz.getDeclaredConstructor(parameters);
                return meth;
            }
            case FAKE_CONSTRUCTOR: {
                try {
                    Class<?> c = clazz.getClassLoader().loadClass(md.getClassName());
                    Constructor<?> meth = c.getDeclaredConstructor(parameters);
                    return meth;
                }
                catch (NoSuchMethodException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        throw new NoSuchMethodException();
    }

    public static Class<?> getDeclaringClass(Constructor<?> f) {
        Class<?> c = f.getDeclaringClass();
        if (c.getName().startsWith("org.fakereplace.proxies")) {
            return ClassDataStore.instance().getRealClassFromProxyName(c.getName());
        }
        return c;
    }

    public static boolean fakeCallRequired(Constructor<?> method) {
        return method.getDeclaringClass().getName().startsWith("org.fakereplace.proxies");
    }
}

