/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.reflection;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.fakereplace.data.AnnotationDataStore;
import org.fakereplace.data.ModifiedMethod;

public class AnnotationReflection {
    private static boolean heiracheyChanged(Class<?> clazz) {
        for (Class<?> c = clazz; c != Object.class && c != null; c = c.getSuperclass()) {
            if (!AnnotationDataStore.isClassDataRecorded(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnnotationPresent(Class<?> clazz, Class anType) {
        if (anType.isAnnotationPresent(Inherited.class) && AnnotationReflection.heiracheyChanged(clazz)) {
            for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
                Annotation[] declared;
                if (AnnotationDataStore.isClassDataRecorded(c)) {
                    if (!AnnotationDataStore.isClassAnnotationPresent(c, anType)) continue;
                    return true;
                }
                for (Annotation a : declared = c.getDeclaredAnnotations()) {
                    if (a.annotationType() != anType) continue;
                    return true;
                }
            }
            return false;
        }
        if (AnnotationDataStore.isClassDataRecorded(clazz)) {
            return AnnotationDataStore.isClassAnnotationPresent(clazz, anType);
        }
        return clazz.isAnnotationPresent(anType);
    }

    public static Annotation getAnnotation(Class<?> clazz, Class anType) {
        if (anType.isAnnotationPresent(Inherited.class) && AnnotationReflection.heiracheyChanged(clazz)) {
            Annotation result = null;
            block0: for (Class<?> c = clazz; result == null && c != null && c != Object.class; c = c.getSuperclass()) {
                Annotation[] declared;
                if (AnnotationDataStore.isClassDataRecorded(c)) {
                    result = AnnotationDataStore.getClassAnnotation(c, anType);
                    continue;
                }
                for (Annotation a : declared = c.getDeclaredAnnotations()) {
                    if (a.annotationType() != anType) continue;
                    result = a;
                    continue block0;
                }
            }
            return result;
        }
        if (AnnotationDataStore.isClassDataRecorded(clazz)) {
            return AnnotationDataStore.getClassAnnotation(clazz, anType);
        }
        return clazz.getAnnotation(anType);
    }

    public static Annotation[] getAnnotations(Class<?> clazz) {
        if (AnnotationReflection.heiracheyChanged(clazz)) {
            Annotation[] pres = AnnotationDataStore.isClassDataRecorded(clazz) ? AnnotationDataStore.getClassAnnotations(clazz) : clazz.getDeclaredAnnotations();
            ArrayList<Annotation> result = new ArrayList<Annotation>();
            for (Annotation a : pres) {
                result.add(a);
            }
            for (Class<?> c = clazz.getSuperclass(); c != Object.class && c != null; c = c.getSuperclass()) {
                pres = AnnotationDataStore.isClassDataRecorded(c) ? AnnotationDataStore.getClassAnnotations(c) : c.getDeclaredAnnotations();
                for (Annotation a : pres) {
                    if (!a.annotationType().isAnnotationPresent(Inherited.class)) continue;
                    result.add(a);
                }
            }
            Annotation[] ret = new Annotation[result.size()];
            int count = 0;
            for (Annotation a : result) {
                ret[count++] = a;
            }
            return ret;
        }
        return clazz.getAnnotations();
    }

    public static Annotation[] getDeclaredAnnotations(Class<?> clazz) {
        if (AnnotationDataStore.isClassDataRecorded(clazz)) {
            Annotation[] result = AnnotationDataStore.getClassAnnotations(clazz);
            return result;
        }
        return clazz.getDeclaredAnnotations();
    }

    public static boolean isAnnotationPresent(Field clazz, Class anType) {
        if (AnnotationDataStore.isFieldDataRecorded(clazz)) {
            boolean result = AnnotationDataStore.isFieldAnnotationPresent(clazz, anType);
            return result;
        }
        return clazz.isAnnotationPresent(anType);
    }

    public static Annotation getAnnotation(Field clazz, Class anType) {
        if (AnnotationDataStore.isFieldDataRecorded(clazz)) {
            Annotation result = AnnotationDataStore.getFieldAnnotation(clazz, anType);
            return result;
        }
        return clazz.getAnnotation(anType);
    }

    public static Annotation[] getAnnotations(Field clazz) {
        if (AnnotationDataStore.isFieldDataRecorded(clazz)) {
            Annotation[] result = AnnotationDataStore.getFieldAnnotations(clazz);
            return result;
        }
        return clazz.getAnnotations();
    }

    public static Annotation[] getDeclaredAnnotations(Field clazz) {
        if (AnnotationDataStore.isFieldDataRecorded(clazz)) {
            Annotation[] result = AnnotationDataStore.getFieldAnnotations(clazz);
            return result;
        }
        return clazz.getDeclaredAnnotations();
    }

    public static boolean isAnnotationPresent(Method clazz, Class anType) {
        if (AnnotationDataStore.isMethodDataRecorded(clazz)) {
            boolean result = AnnotationDataStore.isMethodAnnotationPresent(clazz, anType);
            return result;
        }
        return clazz.isAnnotationPresent(anType);
    }

    public static Annotation getAnnotation(Method clazz, Class anType) {
        if (AnnotationDataStore.isMethodDataRecorded(clazz)) {
            Annotation result = AnnotationDataStore.getMethodAnnotation(clazz, anType);
            return result;
        }
        return clazz.getAnnotation(anType);
    }

    public static Annotation[] getAnnotations(Method clazz) {
        if (AnnotationDataStore.isMethodDataRecorded(clazz)) {
            Annotation[] result = AnnotationDataStore.getMethodAnnotations(clazz);
            int rc = 0;
            boolean found = false;
            for (Annotation a : result) {
                if (!(a instanceof ModifiedMethod)) continue;
                found = true;
                break;
            }
            if (!found) {
                return result;
            }
            Annotation[] ret = new Annotation[result.length - 1];
            for (Annotation a : result) {
                if (a instanceof ModifiedMethod) continue;
                ret[rc] = a;
                ++rc;
            }
            return ret;
        }
        if (clazz.isAnnotationPresent(ModifiedMethod.class)) {
            Annotation[] d = clazz.getAnnotations();
            Annotation[] ret = new Annotation[d.length - 1];
            int rc = 0;
            for (Annotation a : d) {
                if (a instanceof ModifiedMethod) continue;
                ret[rc] = a;
                ++rc;
            }
            return ret;
        }
        return clazz.getAnnotations();
    }

    public static Annotation[] getDeclaredAnnotations(Method clazz) {
        if (AnnotationDataStore.isMethodDataRecorded(clazz)) {
            Annotation[] result = AnnotationDataStore.getMethodAnnotations(clazz);
            int rc = 0;
            boolean found = false;
            for (Annotation a : result) {
                if (!(a instanceof ModifiedMethod)) continue;
                found = true;
                break;
            }
            if (!found) {
                return result;
            }
            Annotation[] ret = new Annotation[result.length - 1];
            for (Annotation a : result) {
                if (a instanceof ModifiedMethod) continue;
                ret[rc] = a;
                ++rc;
            }
            return ret;
        }
        if (clazz.isAnnotationPresent(ModifiedMethod.class)) {
            Annotation[] d = clazz.getDeclaredAnnotations();
            Annotation[] ret = new Annotation[d.length - 1];
            int rc = 0;
            for (Annotation a : d) {
                if (a instanceof ModifiedMethod) continue;
                ret[rc] = a;
                ++rc;
            }
            return ret;
        }
        return clazz.getDeclaredAnnotations();
    }

    public static Annotation[][] getParameterAnnotations(Method clazz) {
        if (AnnotationDataStore.isMethodDataRecorded(clazz)) {
            Annotation[][] result = AnnotationDataStore.getMethodParameterAnnotations(clazz);
            return result;
        }
        return clazz.getParameterAnnotations();
    }

    public static boolean isAnnotationPresent(Constructor<?> clazz, Class anType) {
        if (AnnotationDataStore.isConstructorDataRecorded(clazz)) {
            boolean result = AnnotationDataStore.isConstructorAnnotationPresent(clazz, anType);
            return result;
        }
        return clazz.isAnnotationPresent(anType);
    }

    public static Annotation getAnnotation(Constructor<?> clazz, Class anType) {
        if (AnnotationDataStore.isConstructorDataRecorded(clazz)) {
            Annotation result = AnnotationDataStore.getConstructorAnnotation(clazz, anType);
            return result;
        }
        return clazz.getAnnotation(anType);
    }

    public static Annotation[] getAnnotations(Constructor<?> clazz) {
        if (AnnotationDataStore.isConstructorDataRecorded(clazz)) {
            Annotation[] result = AnnotationDataStore.getConstructorAnnotations(clazz);
            return result;
        }
        return clazz.getAnnotations();
    }

    public static Annotation[] getDeclaredAnnotations(Constructor<?> clazz) {
        if (AnnotationDataStore.isConstructorDataRecorded(clazz)) {
            Annotation[] result = AnnotationDataStore.getConstructorAnnotations(clazz);
            return result;
        }
        return clazz.getDeclaredAnnotations();
    }

    public static Annotation[][] getParameterAnnotations(Constructor<?> clazz) {
        if (AnnotationDataStore.isConstructorDataRecorded(clazz)) {
            Annotation[][] result = AnnotationDataStore.getMethodParameterAnnotations(clazz);
            return result;
        }
        return clazz.getParameterAnnotations();
    }

    public static boolean isAnnotationPresent(AnnotatedElement clazz, Class anType) {
        if (clazz instanceof Class) {
            return AnnotationReflection.isAnnotationPresent((Class)clazz, anType);
        }
        if (clazz instanceof Field) {
            return AnnotationReflection.isAnnotationPresent((Field)clazz, anType);
        }
        if (clazz instanceof Method) {
            return AnnotationReflection.isAnnotationPresent((Method)clazz, anType);
        }
        if (clazz instanceof Constructor) {
            return AnnotationReflection.isAnnotationPresent((Constructor)clazz, anType);
        }
        return clazz.isAnnotationPresent(anType);
    }

    public static Annotation getAnnotation(AnnotatedElement clazz, Class anType) {
        if (clazz instanceof Class) {
            return AnnotationReflection.getAnnotation((Class)clazz, anType);
        }
        if (clazz instanceof Field) {
            return AnnotationReflection.getAnnotation((Field)clazz, anType);
        }
        if (clazz instanceof Method) {
            return AnnotationReflection.getAnnotation((Method)clazz, anType);
        }
        if (clazz instanceof Constructor) {
            return AnnotationReflection.getAnnotation((Constructor)clazz, anType);
        }
        return clazz.getAnnotation(anType);
    }

    public static Annotation[] getAnnotations(AnnotatedElement clazz) {
        if (clazz instanceof Class) {
            return AnnotationReflection.getAnnotations((Class)clazz);
        }
        if (clazz instanceof Field) {
            return AnnotationReflection.getAnnotations((Field)clazz);
        }
        if (clazz instanceof Method) {
            return AnnotationReflection.getAnnotations((Method)clazz);
        }
        if (clazz instanceof Constructor) {
            return AnnotationReflection.getAnnotations((Constructor)clazz);
        }
        return clazz.getAnnotations();
    }

    public static Annotation[] getDeclaredAnnotations(AnnotatedElement clazz) {
        if (clazz instanceof Class) {
            return AnnotationReflection.getDeclaredAnnotations((Class)clazz);
        }
        if (clazz instanceof Field) {
            return AnnotationReflection.getDeclaredAnnotations((Field)clazz);
        }
        if (clazz instanceof Method) {
            return AnnotationReflection.getDeclaredAnnotations((Method)clazz);
        }
        if (clazz instanceof Constructor) {
            return AnnotationReflection.getDeclaredAnnotations((Constructor)clazz);
        }
        return clazz.getDeclaredAnnotations();
    }
}

