/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.manip.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.fakereplace.com.google.common.collect.MapMaker;
import org.fakereplace.manip.util.ClassLoaderFiltered;
import org.fakereplace.manip.util.MapFunction;

public class ManipulationDataStore<T extends ClassLoaderFiltered<T>> {
    private final ClassLoader NULL_CLASS_LOADER = new ClassLoader(){};
    private final Map<ClassLoader, ConcurrentMap<String, Set<T>>> cldata = new MapMaker().weakKeys().makeComputingMap(new MapFunction(false));

    public Map<String, Set<T>> getManipulationData(ClassLoader loader) {
        if (loader == null) {
            loader = this.NULL_CLASS_LOADER;
        }
        HashMap<String, Set<T>> ret = new HashMap<String, Set<T>>();
        for (Map.Entry<ClassLoader, ConcurrentMap<String, Set<T>>> centry : this.cldata.entrySet()) {
            for (Map.Entry e : centry.getValue().entrySet()) {
                HashSet set = new HashSet();
                ret.put((String)e.getKey(), set);
                for (ClassLoaderFiltered f : (Set)e.getValue()) {
                    if (!ManipulationDataStore.includeClassLoader(loader, f.getClassLoader())) continue;
                    set.add(f.getInstance());
                }
            }
        }
        return ret;
    }

    public void add(String name, T mdata) {
        Set existing;
        ConcurrentMap<String, Set<T>> data;
        Set<Object> store;
        ClassLoader loader = mdata.getClassLoader();
        if (loader == null) {
            loader = this.NULL_CLASS_LOADER;
        }
        if ((store = (CopyOnWriteArraySet<T>)(data = this.cldata.get(loader)).get(name)) == null && (existing = (Set)data.putIfAbsent(name, store = new CopyOnWriteArraySet<T>())) != null) {
            store = existing;
        }
        store.add(mdata);
    }

    public static boolean includeClassLoader(ClassLoader loaderOfClassBeingManipulated, ClassLoader loaderOfManipulatedClass) {
        if (loaderOfManipulatedClass == null) {
            return true;
        }
        for (ClassLoader loader = loaderOfClassBeingManipulated; loader != null; loader = loader.getParent()) {
            if (loader != loaderOfManipulatedClass) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "ManipulationDataStore{cldata=" + this.cldata + '}';
    }

    public void remove(String className, ClassLoader classLoader) {
        Map data;
        if (classLoader == null) {
            classLoader = this.NULL_CLASS_LOADER;
        }
        if ((data = (Map)this.cldata.get(classLoader)).containsKey(className)) {
            Set set = (Set)data.get(className);
            Iterator i = set.iterator();
            while (i.hasNext()) {
                ClassLoaderFiltered val = (ClassLoaderFiltered)i.next();
                if (val.getClassLoader() != classLoader) continue;
                i.remove();
            }
        }
    }

    public Map<ClassLoader, ConcurrentMap<String, Set<T>>> getRawData() {
        return this.cldata;
    }
}

