/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.manip;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import org.fakereplace.classloading.ProxyDefinitionStore;
import org.fakereplace.com.google.common.base.Function;
import org.fakereplace.com.google.common.collect.MapMaker;
import org.fakereplace.data.ClassDataStore;
import org.fakereplace.javassist.bytecode.ClassFile;
import org.fakereplace.javassist.bytecode.DuplicateMemberException;
import org.fakereplace.javassist.bytecode.FieldInfo;
import org.fakereplace.javassist.bytecode.SignatureAttribute;
import org.fakereplace.manip.StaticFieldDescriptor;

public class StaticFieldClassFactory {
    private static final Map<StaticFieldDescriptor, String> fieldClasses = new MapMaker().makeComputingMap(new Function<StaticFieldDescriptor, String>(){

        @Override
        public String apply(StaticFieldDescriptor from) {
            String proxyName = ProxyDefinitionStore.getProxyName();
            ClassFile proxy = new ClassFile(false, proxyName, "java.lang.Object");
            ClassDataStore.instance().registerProxyName(from.getClazz(), proxyName);
            proxy.setAccessFlags(1);
            FieldInfo newField = new FieldInfo(proxy.getConstPool(), from.getName(), from.getDescriptor());
            newField.setAccessFlags(9);
            if (from.getSigniture() != null) {
                SignatureAttribute sig = new SignatureAttribute(proxy.getConstPool(), from.getSigniture());
                newField.addAttribute(sig);
            }
            try {
                proxy.addField(newField);
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(bytes);
                try {
                    proxy.write(dos);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                ProxyDefinitionStore.saveProxyDefinition(from.getClazz().getClassLoader(), proxyName, bytes.toByteArray());
            }
            catch (DuplicateMemberException e) {
                // empty catch block
            }
            return proxyName;
        }
    });

    public static String getStaticFieldClass(Class<?> clazz, String fieldName, String fieldDescriptor, String signiture) {
        StaticFieldDescriptor d = new StaticFieldDescriptor(clazz, fieldDescriptor, fieldName, signiture);
        return fieldClasses.get(d);
    }
}

