/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.manip;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fakereplace.javassist.bytecode.ClassFile;
import org.fakereplace.javassist.bytecode.CodeIterator;
import org.fakereplace.javassist.bytecode.ConstPool;
import org.fakereplace.javassist.bytecode.MethodInfo;
import org.fakereplace.logging.Logger;
import org.fakereplace.manip.ClassManipulator;
import org.fakereplace.manip.data.VirtualToStaticData;
import org.fakereplace.manip.util.ManipulationDataStore;

public class MethodInvokationManipulator
implements ClassManipulator {
    private final ManipulationDataStore<VirtualToStaticData> data = new ManipulationDataStore();
    private final Logger log = Logger.getLogger(MethodInvokationManipulator.class);

    @Override
    public void clearRewrites(String className, ClassLoader loader) {
        this.data.remove(className, loader);
    }

    public void replaceVirtualMethodInvokationWithStatic(String oldClass, String newClass, String methodName, String methodDesc, String newStaticMethodDesc, ClassLoader classLoader) {
        VirtualToStaticData d = new VirtualToStaticData(oldClass, newClass, methodName, methodDesc, newStaticMethodDesc, null, classLoader);
        this.data.add(oldClass, d);
    }

    public void replaceVirtualMethodInvokationWithLocal(String oldClass, String methodName, String newMethodName, String methodDesc, String newStaticMethodDesc, ClassLoader classLoader) {
        VirtualToStaticData d = new VirtualToStaticData(oldClass, null, methodName, methodDesc, newStaticMethodDesc, newMethodName, classLoader);
        this.data.add(oldClass, d);
    }

    @Override
    public boolean transformClass(ClassFile file, ClassLoader loader, boolean modifiableClass) {
        Map<String, Set<VirtualToStaticData>> virtualToStaticMethod = this.data.getManipulationData(loader);
        HashMap<Integer, VirtualToStaticData> methodCallLocations = new HashMap<Integer, VirtualToStaticData>();
        HashMap<VirtualToStaticData, Integer> newClassPoolLocations = new HashMap<VirtualToStaticData, Integer>();
        HashMap<VirtualToStaticData, Integer> newCallLocations = new HashMap<VirtualToStaticData, Integer>();
        ConstPool pool = file.getConstPool();
        block2: for (int i = 1; i < pool.getSize(); ++i) {
            String methodName;
            String methodDesc;
            String className;
            if (pool.getTag(i) != 10 && pool.getTag(i) != 11) continue;
            if (pool.getTag(i) == 10) {
                className = pool.getMethodrefClassName(i);
                methodDesc = pool.getMethodrefType(i);
                methodName = pool.getMethodrefName(i);
            } else {
                className = pool.getInterfaceMethodrefClassName(i);
                methodDesc = pool.getInterfaceMethodrefType(i);
                methodName = pool.getInterfaceMethodrefName(i);
            }
            if (!virtualToStaticMethod.containsKey(className)) continue;
            for (VirtualToStaticData data : virtualToStaticMethod.get(className)) {
                if (!methodName.equals(data.getMethodName()) || !methodDesc.equals(data.getMethodDesc())) continue;
                methodCallLocations.put(i, data);
                if (newClassPoolLocations.containsKey(data)) continue block2;
                int newCpLoc = data.getNewClass() != null ? pool.addClassInfo(data.getNewClass()) : pool.addClassInfo(file.getName());
                newClassPoolLocations.put(data, newCpLoc);
                int newNameAndType = pool.addNameAndTypeInfo(data.getNewMethodName(), data.getNewStaticMethodDesc());
                newCallLocations.put(data, pool.addMethodrefInfo(newCpLoc, newNameAndType));
                continue block2;
            }
        }
        if (!newClassPoolLocations.isEmpty()) {
            List methods = file.getMethods();
            for (MethodInfo m : methods) {
                try {
                    if (m.getCodeAttribute() == null) continue;
                    CodeIterator it = m.getCodeAttribute().iterator();
                    while (it.hasNext()) {
                        int val;
                        int index = it.next();
                        int op = it.byteAt(index);
                        if (op != 182 && op != 184 && op != 185 && op != 183 || !methodCallLocations.containsKey(val = it.s16bitAt(index + 1))) continue;
                        VirtualToStaticData data = (VirtualToStaticData)methodCallLocations.get(val);
                        it.writeByte(184, index);
                        it.write16bit((Integer)newCallLocations.get(data), index + 1);
                        if (op != 185) continue;
                        it.writeByte(0, index + 3);
                        it.writeByte(0, index + 4);
                    }
                    m.getCodeAttribute().computeMaxStack();
                }
                catch (Exception e) {
                    this.log.error("Bad byte code transforming " + file.getName(), e);
                    e.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }
}

