/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.manip;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fakereplace.javassist.bytecode.Bytecode;
import org.fakereplace.javassist.bytecode.ClassFile;
import org.fakereplace.javassist.bytecode.CodeIterator;
import org.fakereplace.javassist.bytecode.ConstPool;
import org.fakereplace.javassist.bytecode.MethodInfo;
import org.fakereplace.logging.Logger;
import org.fakereplace.manip.ClassManipulator;
import org.fakereplace.manip.data.AddedFieldData;
import org.fakereplace.manip.util.Boxing;
import org.fakereplace.manip.util.ManipulationDataStore;
import org.fakereplace.runtime.FieldDataStore;
import org.fakereplace.util.DescriptorUtils;

public class InstanceFieldManipulator
implements ClassManipulator {
    private static final String FIELD_DATA_STORE_CLASS = FieldDataStore.class.getName();
    private static final Logger log = Logger.getLogger(InstanceFieldManipulator.class);
    private final ManipulationDataStore<AddedFieldData> data = new ManipulationDataStore();

    public void addField(AddedFieldData dt) {
        this.data.add(dt.getClassName(), dt);
    }

    @Override
    public boolean transformClass(ClassFile file, ClassLoader loader, boolean modifiableClass) {
        Map<String, Set<AddedFieldData>> addedFieldData = this.data.getManipulationData(loader);
        if (addedFieldData.isEmpty()) {
            return false;
        }
        HashMap<Integer, AddedFieldData> fieldAccessLocations = new HashMap<Integer, AddedFieldData>();
        ConstPool pool = file.getConstPool();
        block2: for (int i = 1; i < pool.getSize(); ++i) {
            if (pool.getTag(i) != 9 || !addedFieldData.containsKey(pool.getFieldrefClassName(i))) continue;
            for (AddedFieldData data : addedFieldData.get(pool.getFieldrefClassName(i))) {
                if (!pool.getFieldrefName(i).equals(data.getName())) continue;
                fieldAccessLocations.put(i, data);
                continue block2;
            }
        }
        if (!fieldAccessLocations.isEmpty()) {
            List methods = file.getMethods();
            for (MethodInfo m : methods) {
                try {
                    if (m.getCodeAttribute() == null) continue;
                    CodeIterator it = m.getCodeAttribute().iterator();
                    while (it.hasNext()) {
                        Bytecode b;
                        int val;
                        int index = it.next();
                        int op = it.byteAt(index);
                        if (op != 181 && op != 180 || !fieldAccessLocations.containsKey(val = it.s16bitAt(index + 1))) continue;
                        AddedFieldData data = (AddedFieldData)fieldAccessLocations.get(val);
                        int arrayPos = file.getConstPool().addIntegerInfo(data.getArrayIndex());
                        it.writeByte(0, index);
                        it.writeByte(0, index + 1);
                        it.writeByte(0, index + 2);
                        if (op == 181) {
                            b = new Bytecode(file.getConstPool());
                            if (data.getDescriptor().charAt(0) != 'L' && data.getDescriptor().charAt(0) != '[') {
                                Boxing.box(b, data.getDescriptor().charAt(0));
                            }
                            b.addLdc(arrayPos);
                            b.addInvokestatic(FIELD_DATA_STORE_CLASS, "setValue", "(Ljava/lang/Object;Ljava/lang/Object;I)V");
                            it.insertEx(b.get());
                            continue;
                        }
                        if (op != 180) continue;
                        b = new Bytecode(file.getConstPool());
                        b.addLdc(arrayPos);
                        b.addInvokestatic(FIELD_DATA_STORE_CLASS, "getValue", "(Ljava/lang/Object;I)Ljava/lang/Object;");
                        if (DescriptorUtils.isPrimitive(data.getDescriptor())) {
                            Boxing.unbox(b, data.getDescriptor().charAt(0));
                        } else {
                            b.addCheckcast(DescriptorUtils.getTypeStringFromDescriptorFormat(data.getDescriptor()));
                        }
                        it.insertEx(b.get());
                    }
                    m.getCodeAttribute().computeMaxStack();
                }
                catch (Exception e) {
                    log.error("Bad byte code transforming " + file.getName(), e);
                    e.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void clearRewrites(String className, ClassLoader loader) {
        this.data.remove(className, loader);
    }
}

