/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.manip;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.fakereplace.javassist.bytecode.Bytecode;
import org.fakereplace.javassist.bytecode.ClassFile;
import org.fakereplace.javassist.bytecode.CodeIterator;
import org.fakereplace.javassist.bytecode.ConstPool;
import org.fakereplace.javassist.bytecode.MethodInfo;
import org.fakereplace.logging.Logger;
import org.fakereplace.manip.ClassManipulator;
import org.fakereplace.util.JumpMarker;
import org.fakereplace.util.JumpUtils;

public class FieldAccessManipulator
implements ClassManipulator {
    private static final Logger log = Logger.getLogger(FieldAccessManipulator.class);
    private final Map<String, RewriteData> manipulationData = new ConcurrentHashMap<String, RewriteData>();

    @Override
    public void clearRewrites(String className, ClassLoader loader) {
    }

    public FieldAccessManipulator() {
        this.setupData("set", "(Ljava/lang/Object;Ljava/lang/Object;)V", "(Ljava/lang/reflect/Field;Ljava/lang/Object;Ljava/lang/Object;)V", true, false);
        this.setupData("setBoolean", "(Ljava/lang/Object;Z)V", "(Ljava/lang/reflect/Field;Ljava/lang/Object;Z)V", true, false);
        this.setupData("setBtye", "(Ljava/lang/Object;B)V", "(Ljava/lang/reflect/Field;Ljava/lang/Object;B)V", true, false);
        this.setupData("setChar", "(Ljava/lang/Object;C)V", "(Ljava/lang/reflect/Field;Ljava/lang/Object;C)V", true, false);
        this.setupData("setDouble", "(Ljava/lang/Object;D)V", "(Ljava/lang/reflect/Field;Ljava/lang/Object;D)V", true, true);
        this.setupData("setFloat", "(Ljava/lang/Object;F)V", "(Ljava/lang/reflect/Field;Ljava/lang/Object;F)V", true, false);
        this.setupData("setInt", "(Ljava/lang/Object;I)V", "(Ljava/lang/reflect/Field;Ljava/lang/Object;I)V", true, false);
        this.setupData("setLong", "(Ljava/lang/Object;J)V", "(Ljava/lang/reflect/Field;Ljava/lang/Object;J)V", true, true);
        this.setupData("setShort", "(Ljava/lang/Object;S)V", "(Ljava/lang/reflect/Field;Ljava/lang/Object;S)V", true, false);
        this.setupData("get", "(Ljava/lang/Object;)Ljava/lang/Object;", "(Ljava/lang/reflect/Field;Ljava/lang/Object;)Ljava/lang/Object;", false, false);
        this.setupData("getBoolean", "(Ljava/lang/Object;)Z", "(Ljava/lang/reflect/Field;Ljava/lang/Object;)Z", false, false);
        this.setupData("getByte", "(Ljava/lang/Object;)B", "(Ljava/lang/reflect/Field;Ljava/lang/Object;)B", false, false);
        this.setupData("getChar", "(Ljava/lang/Object;)C", "(Ljava/lang/reflect/Field;Ljava/lang/Object;)C", false, false);
        this.setupData("getDouble", "(Ljava/lang/Object;)D", "(Ljava/lang/reflect/Field;Ljava/lang/Object;)D", false, true);
        this.setupData("getFloat", "(Ljava/lang/Object;)F", "(Ljava/lang/reflect/Field;Ljava/lang/Object;)F", false, false);
        this.setupData("getInt", "(Ljava/lang/Object;)I", "(Ljava/lang/reflect/Field;Ljava/lang/Object;)I", false, false);
        this.setupData("getLong", "(Ljava/lang/Object;)J", "(Ljava/lang/reflect/Field;Ljava/lang/Object;)J", false, true);
        this.setupData("getShort", "(Ljava/lang/Object;)S", "(Ljava/lang/reflect/Field;Ljava/lang/Object;)S", false, false);
    }

    private void setupData(String methodName, String descriptor, String newDescriptor, boolean set, boolean wide) {
        RewriteData data = new RewriteData(set, wide, methodName, descriptor, newDescriptor);
        this.manipulationData.put(methodName, data);
    }

    @Override
    public boolean transformClass(ClassFile file, ClassLoader loader, boolean modifiableClass) {
        HashMap<Integer, RewriteData> methodCallLocations = new HashMap<Integer, RewriteData>();
        HashMap<RewriteData, Integer> newClassPoolLocations = new HashMap<RewriteData, Integer>();
        Integer fieldAccessLocation = null;
        ConstPool pool = file.getConstPool();
        for (int i = 1; i < pool.getSize(); ++i) {
            RewriteData data;
            String methodName;
            String className;
            if (pool.getTag(i) != 10 && pool.getTag(i) != 11) continue;
            if (pool.getTag(i) == 10) {
                className = pool.getMethodrefClassName(i);
                methodName = pool.getMethodrefName(i);
            } else {
                className = pool.getInterfaceMethodrefClassName(i);
                methodName = pool.getInterfaceMethodrefName(i);
            }
            if (!className.equals("java.lang.reflect.Field") || (data = this.manipulationData.get(methodName)) == null) continue;
            methodCallLocations.put(i, data);
            if (newClassPoolLocations.containsKey(data)) continue;
            if (fieldAccessLocation == null) {
                fieldAccessLocation = pool.addClassInfo("org.fakereplace.reflection.FieldReflection");
            }
            int newNameAndType = pool.addNameAndTypeInfo(data.getMethodName(), data.getNewMethodDescriptor());
            newClassPoolLocations.put(data, newNameAndType);
        }
        if (fieldAccessLocation != null) {
            List methods = file.getMethods();
            for (MethodInfo m : methods) {
                try {
                    if (m.getCodeAttribute() == null) continue;
                    CodeIterator it = m.getCodeAttribute().iterator();
                    while (it.hasNext()) {
                        int val;
                        int index = it.next();
                        int op = it.byteAt(index);
                        if (op != 182 && op != 184 && op != 185 || !methodCallLocations.containsKey(val = it.s16bitAt(index + 1))) continue;
                        RewriteData data = (RewriteData)methodCallLocations.get(val);
                        Bytecode b = new Bytecode(file.getConstPool());
                        this.prepareForIsFakeFieldCall(b, data);
                        b.addInvokestatic(fieldAccessLocation, "isFakeField", "(Ljava/lang/reflect/Field;)Z");
                        b.add(153);
                        JumpMarker performRealCall = JumpUtils.addJumpInstruction(b);
                        b.addInvokestatic(fieldAccessLocation, data.getMethodName(), data.getNewMethodDescriptor());
                        b.add(167);
                        JumpMarker finish = JumpUtils.addJumpInstruction(b);
                        performRealCall.mark();
                        b.addInvokevirtual("java.lang.reflect.Field", data.getMethodName(), data.getMethodDescriptor());
                        finish.mark();
                        it.writeByte(0, index);
                        it.writeByte(0, index + 1);
                        it.writeByte(0, index + 2);
                        if (op == 185) {
                            it.writeByte(0, index + 3);
                            it.writeByte(0, index + 4);
                        }
                        it.insertEx(b.get());
                    }
                    m.getCodeAttribute().computeMaxStack();
                }
                catch (Exception e) {
                    log.error("Bad byte code transforming " + file.getName() + "." + m.getName(), e);
                }
            }
            return true;
        }
        return false;
    }

    private void prepareForIsFakeFieldCall(Bytecode b, RewriteData data) {
        if (data.isSet()) {
            if (data.isWideValue()) {
                b.add(94);
                b.add(88);
                b.add(94);
                b.add(87);
            } else {
                b.add(91);
                b.add(87);
                b.add(91);
                b.add(87);
                b.add(91);
            }
        } else {
            b.add(90);
            b.add(87);
            b.add(90);
        }
    }

    private static class RewriteData {
        private final boolean set;
        private final boolean wideValue;
        private final String methodName;
        private final String methodDescriptor;
        private final String newMethodDescriptor;

        public RewriteData(boolean set, boolean wideValue, String methodName, String methodDescriptor, String newMethodDescriptor) {
            this.set = set;
            this.wideValue = wideValue;
            this.methodName = methodName;
            this.methodDescriptor = methodDescriptor;
            this.newMethodDescriptor = newMethodDescriptor;
        }

        public boolean isSet() {
            return this.set;
        }

        public boolean isWideValue() {
            return this.wideValue;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getMethodDescriptor() {
            return this.methodDescriptor;
        }

        public String getNewMethodDescriptor() {
            return this.newMethodDescriptor;
        }
    }
}

