/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.integration.metawidget;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.fakereplace.api.ClassChangeAware;
import org.fakereplace.classloading.ClassIdentifier;
import org.fakereplace.data.InstanceTracker;

public class ClassRedefinitionPlugin
implements ClassChangeAware {
    private static Method remove;

    private static Field getField(Class<?> clazz, String name) throws NoSuchFieldException {
        if (clazz == Object.class) {
            throw new NoSuchFieldException();
        }
        try {
            return clazz.getDeclaredField(name);
        }
        catch (Exception exception) {
            return ClassRedefinitionPlugin.getField(clazz.getSuperclass(), name);
        }
    }

    @Override
    public void beforeChange(Class<?>[] changed, ClassIdentifier[] added) {
    }

    @Override
    public void notify(Class<?>[] changed, ClassIdentifier[] added) {
        Set<?> data = InstanceTracker.get("org.metawidget.inspector.impl.actionstyle.BaseActionStyle");
        for (Object i : data) {
            ClassRedefinitionPlugin.clearMap(changed, i, "mActionCache");
        }
        data = InstanceTracker.get("org.metawidget.inspector.impl.propertystyle.BasePropertyStyle");
        for (Object i : data) {
            ClassRedefinitionPlugin.clearMap(changed, i, "mPropertiesCache");
        }
    }

    public static void clearMap(Class<?>[] changed, Object i, String cacheName) {
        try {
            Field f = ClassRedefinitionPlugin.getField(i.getClass(), cacheName);
            f.setAccessible(true);
            Object map = f.get(i);
            for (Class<?> c : changed) {
                remove.invoke(map, c);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            remove = Map.class.getMethod("remove", Object.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

