/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.integration.jbossas;

import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.fakereplace.boot.Environment;
import org.fakereplace.logging.Logger;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.vfs.VirtualFile;

public class JBossAsEnvironment
implements Environment {
    private final Map<ModuleIdentifier, ModuleClassLoader> loadersByModuleIdentifier = new ConcurrentHashMap<ModuleIdentifier, ModuleClassLoader>();
    private final Map<ModuleClassLoader, Map<String, Long>> timestamps = new ConcurrentHashMap<ModuleClassLoader, Map<String, Long>>();
    private final Logger log = Logger.getLogger(JBossAsEnvironment.class);

    @Override
    public boolean isClassReplaceable(String className, ClassLoader loader) {
        return loader instanceof ModuleClassLoader && ((ModuleClassLoader)loader).getModule().getIdentifier().toString().startsWith("deployment.");
    }

    @Override
    public void recordTimestamp(String className, ClassLoader loader) {
        this.log.trace("Recording timestamp for " + className);
        if (!(loader instanceof ModuleClassLoader)) {
            return;
        }
        Map<Object, Object> stamps = null;
        ModuleClassLoader moduleClassLoader = (ModuleClassLoader)loader;
        ModuleIdentifier moduleIdentifier = moduleClassLoader.getModule().getIdentifier();
        if (this.loadersByModuleIdentifier.containsKey(moduleIdentifier)) {
            ModuleClassLoader oldLoader = this.loadersByModuleIdentifier.get(moduleIdentifier);
            if (oldLoader != moduleClassLoader) {
                this.loadersByModuleIdentifier.put(moduleIdentifier, moduleClassLoader);
                stamps = new ConcurrentHashMap();
                this.timestamps.put(moduleClassLoader, stamps);
            } else {
                stamps = this.timestamps.get(moduleClassLoader);
            }
        } else {
            this.loadersByModuleIdentifier.put(moduleIdentifier, moduleClassLoader);
            stamps = new ConcurrentHashMap();
            this.timestamps.put(moduleClassLoader, stamps);
        }
        URL file = loader.getResource(className.replace(".", "/") + ".class");
        className = className.replace("/", ".");
        if (file != null) {
            try {
                URLConnection connection = file.openConnection();
                long lastModified = connection.getLastModified();
                stamps.put(className, lastModified);
                this.log.trace("Timestamp for " + className + " is " + lastModified);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Set<Class> getUpdatedClasses(String deploymentName, Map<String, Long> updatedClasses) {
        this.log.info("Finding classes for " + deploymentName);
        this.log.trace("Server time stamps: " + this.timestamps);
        ServiceController<DeploymentUnit> deploymentService = this.deploymentService(deploymentName);
        if (deploymentService == null) {
            this.log.error("Could not find deployment " + deploymentName);
            return Collections.emptySet();
        }
        ModuleIdentifier moduleId = this.getModuleIdentifier(deploymentService);
        ModuleClassLoader loader = this.loadersByModuleIdentifier.get(moduleId);
        if (loader == null) {
            this.log.error("Could not find module " + moduleId);
            return Collections.emptySet();
        }
        Map<String, Long> timestamps = this.timestamps.get(loader);
        HashSet<Class> ret = new HashSet<Class>();
        for (Map.Entry<String, Long> entry : updatedClasses.entrySet()) {
            StringBuilder traceString = new StringBuilder();
            traceString.append("Comparing class ");
            traceString.append(entry.getKey());
            traceString.append(" TS: ");
            traceString.append(entry.getValue());
            if (timestamps.containsKey(entry.getKey())) {
                traceString.append(" Server TS: ");
                Long timestamp = timestamps.get(entry.getKey());
                traceString.append(timestamp);
                if (timestamp < entry.getValue()) {
                    traceString.append(" replacing");
                    try {
                        ret.add(loader.loadClass(entry.getKey()));
                        timestamps.put(entry.getKey(), entry.getValue());
                    }
                    catch (ClassNotFoundException e) {
                        System.err.println("Could not load class " + entry);
                    }
                } else {
                    traceString.append(" not replacing");
                }
            } else {
                traceString.append(" Server TS not found");
            }
            this.log.trace(traceString.toString());
        }
        return ret;
    }

    @Override
    public Set<String> getUpdatedResources(String deploymentName, Map<String, Long> updatedResources) {
        ServiceController<DeploymentUnit> deploymentService = this.deploymentService(deploymentName);
        if (deploymentService == null) {
            return Collections.emptySet();
        }
        ModuleIdentifier moduleId = this.getModuleIdentifier(deploymentService);
        ModuleClassLoader loader = this.loadersByModuleIdentifier.get(moduleId);
        if (loader == null) {
            return Collections.emptySet();
        }
        DeploymentUnit deploymentUnit = (DeploymentUnit)deploymentService.getValue();
        ResourceRoot root = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        HashSet<String> resources = new HashSet<String>();
        for (Map.Entry<String, Long> entry : updatedResources.entrySet()) {
            VirtualFile file = root.getRoot().getChild(entry.getKey());
            if (!file.exists()) continue;
            long last = file.getLastModified();
            if (entry.getValue() <= last) continue;
            resources.add(entry.getKey());
        }
        return resources;
    }

    private ServiceController<DeploymentUnit> deploymentService(String deploymentName) {
        ServiceController deploymentService = CurrentServiceContainer.getServiceContainer().getService(Services.deploymentUnitName((String)deploymentName));
        if (deploymentService == null) {
            for (ServiceName serviceName : CurrentServiceContainer.getServiceContainer().getServiceNames()) {
                String[] parts;
                if (!Services.JBOSS_DEPLOYMENT_SUB_UNIT.isParentOf(serviceName) || !(parts = serviceName.toArray())[parts.length - 1].equals(deploymentName)) continue;
                deploymentService = CurrentServiceContainer.getServiceContainer().getService(serviceName);
                break;
            }
        }
        return deploymentService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateResource(String archiveName, Map<String, byte[]> replacedResources) {
        ServiceController<DeploymentUnit> deploymentService = this.deploymentService(archiveName);
        if (deploymentService == null) {
            return;
        }
        ModuleIdentifier moduleId = this.getModuleIdentifier(deploymentService);
        ModuleClassLoader loader = this.loadersByModuleIdentifier.get(moduleId);
        if (loader == null) {
            return;
        }
        DeploymentUnit deploymentUnit = (DeploymentUnit)deploymentService.getValue();
        ResourceRoot root = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        for (Map.Entry<String, byte[]> entry : replacedResources.entrySet()) {
            VirtualFile file = root.getRoot().getChild(entry.getKey());
            try {
                FileOutputStream stream = new FileOutputStream(file.getPhysicalFile(), false);
                try {
                    stream.write(entry.getValue());
                    stream.flush();
                }
                finally {
                    stream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private ModuleIdentifier getModuleIdentifier(ServiceController<DeploymentUnit> deploymentArchive) {
        return (ModuleIdentifier)((DeploymentUnit)deploymentArchive.getValue()).getAttachment(Attachments.MODULE_IDENTIFIER);
    }
}

