/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.data;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.fakereplace.data.ClassDataStore;
import org.fakereplace.data.MemberType;
import org.fakereplace.util.DescriptorUtils;

public class MethodData {
    private final String methodName;
    private final String descriptor;
    private final String argumentDescriptor;
    private final String returnTypeDescriptor;
    private final MemberType type;
    private final int accessFlags;
    private final int methodNo;
    private final String className;
    private final boolean finalMethod;

    public MethodData(String name, String descriptor, String className, MemberType type, int accessFlags, boolean finalMethod) {
        this.methodName = name;
        this.descriptor = descriptor;
        this.returnTypeDescriptor = DescriptorUtils.getReturnType(descriptor);
        this.argumentDescriptor = DescriptorUtils.getArgumentString(descriptor);
        this.className = className;
        this.type = type;
        this.accessFlags = accessFlags;
        this.methodNo = 0;
        this.finalMethod = finalMethod;
    }

    public MethodData(String name, String descriptor, String className, MemberType type, int accessFlags, int methodNo) {
        this.methodName = name;
        this.descriptor = descriptor;
        this.returnTypeDescriptor = DescriptorUtils.getReturnType(descriptor);
        this.argumentDescriptor = DescriptorUtils.getArgumentString(descriptor);
        this.className = className;
        this.type = type;
        this.accessFlags = accessFlags;
        this.methodNo = methodNo;
        this.finalMethod = false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof MethodData) {
            MethodData m = (MethodData)obj;
            if (m.className.equals(this.className) && m.methodName.equals(this.methodName) && m.descriptor.equals(this.descriptor)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return (this.className + this.methodName + this.descriptor).hashCode();
    }

    public String getClassName() {
        return this.className;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public MemberType getType() {
        return this.type;
    }

    public boolean isStatic() {
        return (this.accessFlags & 8) != 0;
    }

    public String getArgumentDescriptor() {
        return this.argumentDescriptor;
    }

    public Method getMethod(Class<?> actualClass) throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        Class<?>[] methodDesc = DescriptorUtils.argumentStringToClassArray(this.descriptor, actualClass);
        Method method = actualClass.getDeclaredMethod(this.methodName, methodDesc);
        return method;
    }

    public Method getMethodToInvoke(Class<?> actualClass) throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        Class<?>[] methodDesc;
        if (this.type == MemberType.FAKE && !this.isStatic()) {
            methodDesc = DescriptorUtils.argumentStringToClassArray(this.descriptor, actualClass);
            Class[] ret = new Class[methodDesc.length + 1];
            ret[0] = ClassDataStore.instance().getRealClassFromProxyName(actualClass.getName());
            for (int i = 0; i < methodDesc.length; ++i) {
                ret[i + 1] = methodDesc[i];
            }
            methodDesc = ret;
        } else {
            methodDesc = DescriptorUtils.argumentStringToClassArray(this.descriptor, actualClass);
        }
        Method method = actualClass.getDeclaredMethod(this.methodName, methodDesc);
        return method;
    }

    public Constructor<?> getConstructor(Class<?> actualClass) throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        Class<?>[] methodDesc = DescriptorUtils.argumentStringToClassArray(this.descriptor, actualClass);
        Constructor<?> method = actualClass.getDeclaredConstructor(methodDesc);
        return method;
    }

    public int getMethodNo() {
        return this.methodNo;
    }

    public String getReturnTypeDescriptor() {
        return this.returnTypeDescriptor;
    }

    public boolean isFinalMethod() {
        return this.finalMethod;
    }
}

