/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.data;

import java.lang.reflect.Field;
import org.fakereplace.data.MemberType;
import org.fakereplace.javassist.bytecode.AccessFlag;
import org.fakereplace.javassist.bytecode.FieldInfo;

public class FieldData {
    private final int accessFlags;
    private final boolean priv;
    private final boolean pack;
    private final boolean prot;
    private final String name;
    private final String type;
    private final MemberType memberType;
    private final String className;

    public FieldData(FieldInfo info, MemberType memberType, String className, int modifiers) {
        this.accessFlags = modifiers;
        this.pack = AccessFlag.isPackage(modifiers);
        this.priv = AccessFlag.isPrivate(modifiers);
        this.prot = AccessFlag.isProtected(modifiers);
        this.type = info.getDescriptor();
        this.name = info.getName();
        this.className = className;
        this.memberType = memberType;
    }

    public FieldData(Field field) {
        this.accessFlags = field.getModifiers();
        this.pack = AccessFlag.isPackage(this.accessFlags);
        this.priv = AccessFlag.isPrivate(this.accessFlags);
        this.prot = AccessFlag.isProtected(this.accessFlags);
        this.type = field.getType().getName();
        this.memberType = MemberType.NORMAL;
        this.className = field.getDeclaringClass().getName();
        this.name = field.getName();
    }

    public FieldData(FieldData other, MemberType type) {
        this.accessFlags = other.accessFlags;
        this.pack = other.pack;
        this.priv = other.priv;
        this.prot = other.prot;
        this.type = other.type;
        this.name = other.name;
        this.className = other.className;
        this.memberType = type;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof FieldData) {
            FieldData m = (FieldData)obj;
            if (m.className.equals(this.className) && m.name.equals(this.name) && m.type.equals(this.type)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return (this.className + this.name).hashCode();
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getClassName() {
        return this.className;
    }

    public MemberType getMemberType() {
        return this.memberType;
    }

    public Field getField(Class<?> actualClass) throws ClassNotFoundException, SecurityException, NoSuchFieldException {
        Field method = actualClass.getDeclaredField(this.name);
        return method;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public boolean isPriv() {
        return this.priv;
    }

    public boolean isPack() {
        return this.pack;
    }

    public boolean isProt() {
        return this.prot;
    }
}

