/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.classloading;

import java.util.Map;
import org.fakereplace.classloading.ClassIdentifier;
import org.fakereplace.classloading.ProxyDefinitionStore;
import org.fakereplace.com.google.common.collect.MapMaker;
import org.fakereplace.transformation.MainTransformer;

public class ClassLookupManager {
    private static Map<ClassIdentifier, byte[]> classData = new MapMaker().makeMap();

    public static byte[] getClassData(String className, Object cl) {
        if (!(cl instanceof ClassLoader)) {
            return null;
        }
        ClassLoader loader = (ClassLoader)cl;
        if (className.startsWith("org.fakereplace.proxies")) {
            return ProxyDefinitionStore.getProxyDefinition(loader, className);
        }
        if (className.startsWith("org.fakereplace.integration")) {
            return MainTransformer.getIntegrationClass(loader, className);
        }
        return classData.get(new ClassIdentifier(className, loader));
    }

    public static void addClassInfo(String className, ClassLoader loader, byte[] data) {
        classData.put(new ClassIdentifier(className, loader), data);
    }
}

