/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.util.Objects;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.LoadingState;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONArray;
import org.json.JSONObject;

class ArraySchemaLoader {
    private final LoadingState ls;
    private final SchemaLoader defaultLoader;

    public ArraySchemaLoader(LoadingState ls, SchemaLoader defaultLoader) {
        this.ls = Objects.requireNonNull(ls, "ls cannot be null");
        this.defaultLoader = Objects.requireNonNull(defaultLoader, "defaultLoader cannot be null");
    }

    ArraySchema.Builder load() {
        ArraySchema.Builder builder = ArraySchema.builder();
        this.ls.ifPresent("minItems", Integer.class, builder::minItems);
        this.ls.ifPresent("maxItems", Integer.class, builder::maxItems);
        this.ls.ifPresent("uniqueItems", Boolean.class, builder::uniqueItems);
        if (this.ls.schemaJson.has("additionalItems")) {
            this.ls.typeMultiplexer("additionalItems", this.ls.schemaJson.get("additionalItems")).ifIs(Boolean.class).then(builder::additionalItems).ifObject().then(jsonObj -> builder.schemaOfAdditionalItems((Schema)this.defaultLoader.loadChild((JSONObject)jsonObj).build())).requireAny();
        }
        if (this.ls.schemaJson.has("items")) {
            this.ls.typeMultiplexer("items", this.ls.schemaJson.get("items")).ifObject().then(itemSchema -> builder.allItemSchema((Schema)this.defaultLoader.loadChild((JSONObject)itemSchema).build())).ifIs(JSONArray.class).then(arr -> this.buildTupleSchema(builder, (JSONArray)arr)).requireAny();
        }
        return builder;
    }

    private void buildTupleSchema(ArraySchema.Builder builder, JSONArray itemSchema) {
        for (int i = 0; i < itemSchema.length(); ++i) {
            this.ls.typeMultiplexer(itemSchema.get(i)).ifObject().then(schema -> builder.addItemSchema((Schema)this.defaultLoader.loadChild((JSONObject)schema).build())).requireAny();
        }
    }
}

