/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.bootstrap.JavaVersion;
import org.elasticsearch.test.rest.ESRestTestCase;

public final class Features {
    private static final List<String> SUPPORTED = Collections.unmodifiableList(Arrays.asList("catch_unauthorized", "default_shards", "embedded_stash_key", "headers", "node_selector", "stash_in_key", "stash_in_path", "stash_path_replace", "warnings", "yaml", "contains", "transform_and_set", "arbitrary_key", "allowed_warnings"));
    private static final String SPI_ON_CLASSPATH_SINCE_JDK_9 = "spi_on_classpath_jdk9";

    private Features() {
    }

    public static boolean areAllSupported(List<String> features) {
        for (String feature : features) {
            if (!(feature.equals("xpack") ? false == ESRestTestCase.hasXPack() : (feature.equals("no_xpack") ? ESRestTestCase.hasXPack() : false == Features.isSupported(feature)))) continue;
            return false;
        }
        return true;
    }

    private static boolean isSupported(String feature) {
        if (feature.equals(SPI_ON_CLASSPATH_SINCE_JDK_9) && JavaVersion.current().compareTo(JavaVersion.parse((String)"9")) >= 0) {
            return true;
        }
        return SUPPORTED.contains(feature);
    }
}

