/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.disruption;

import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.test.InternalTestCluster;
import org.elasticsearch.test.disruption.SingleNodeDisruption;

public class BusyMasterServiceDisruption
extends SingleNodeDisruption {
    private final AtomicBoolean active = new AtomicBoolean();
    private final Priority priority;

    public BusyMasterServiceDisruption(Random random, Priority priority) {
        super(random);
        this.priority = priority;
    }

    @Override
    public void startDisrupting() {
        this.disruptedNode = this.cluster.getMasterName();
        String disruptionNodeCopy = this.disruptedNode;
        if (disruptionNodeCopy == null) {
            return;
        }
        ClusterService clusterService = this.cluster.getInstance(ClusterService.class, disruptionNodeCopy);
        if (clusterService == null) {
            return;
        }
        this.logger.info("making master service busy on node [{}] at priority [{}]", (Object)disruptionNodeCopy, (Object)this.priority);
        this.active.set(true);
        this.submitTask(clusterService);
    }

    private void submitTask(final ClusterService clusterService) {
        clusterService.getMasterService().submitStateUpdateTask("service_disruption_block", (ClusterStateTaskConfig)new ClusterStateUpdateTask(this.priority){

            public ClusterState execute(ClusterState currentState) {
                if (BusyMasterServiceDisruption.this.active.get()) {
                    BusyMasterServiceDisruption.this.submitTask(clusterService);
                }
                return currentState;
            }

            public void onFailure(String source, Exception e) {
                BusyMasterServiceDisruption.this.logger.error("unexpected error during disruption", (Throwable)e);
            }
        });
    }

    @Override
    public void stopDisrupting() {
        this.active.set(false);
    }

    @Override
    public void removeAndEnsureHealthy(InternalTestCluster cluster) {
        this.removeFromCluster(cluster);
    }

    @Override
    public TimeValue expectedTimeToHeal() {
        return TimeValue.timeValueMinutes((long)0L);
    }
}

