/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.ParsedAggregation;
import org.elasticsearch.search.aggregations.bucket.InternalSingleBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.ParsedSingleBucketAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalMax;
import org.elasticsearch.search.aggregations.metrics.InternalMin;
import org.elasticsearch.test.InternalAggregationTestCase;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;

public abstract class InternalSingleBucketAggregationTestCase<T extends InternalSingleBucketAggregation>
extends InternalAggregationTestCase<T> {
    private boolean hasInternalMax;
    private boolean hasInternalMin;
    public Supplier<InternalAggregations> subAggregationsSupplier;

    public void setUp() throws Exception {
        super.setUp();
        this.hasInternalMax = InternalSingleBucketAggregationTestCase.randomBoolean();
        this.hasInternalMin = InternalSingleBucketAggregationTestCase.randomBoolean();
        this.subAggregationsSupplier = () -> {
            ArrayList<Object> aggs = new ArrayList<Object>();
            if (this.hasInternalMax) {
                aggs.add(new InternalMax("max", InternalSingleBucketAggregationTestCase.randomDouble(), InternalSingleBucketAggregationTestCase.randomNumericDocValueFormat(), Collections.emptyMap()));
            }
            if (this.hasInternalMin) {
                aggs.add(new InternalMin("min", InternalSingleBucketAggregationTestCase.randomDouble(), InternalSingleBucketAggregationTestCase.randomNumericDocValueFormat(), Collections.emptyMap()));
            }
            return InternalAggregations.from(aggs);
        };
    }

    protected abstract T createTestInstance(String var1, long var2, InternalAggregations var4, Map<String, Object> var5);

    protected abstract void extraAssertReduced(T var1, List<T> var2);

    @Override
    protected final T createTestInstance(String name, Map<String, Object> metadata) {
        long docCount = InternalSingleBucketAggregationTestCase.between(0, Integer.MAX_VALUE);
        return this.createTestInstance(name, docCount, this.subAggregationsSupplier.get(), metadata);
    }

    @Override
    protected T mutateInstance(T instance) {
        String name = instance.getName();
        long docCount = instance.getDocCount();
        InternalAggregations aggregations = instance.getAggregations();
        HashMap<String, Object> metadata = instance.getMetadata();
        switch (InternalSingleBucketAggregationTestCase.between(0, 3)) {
            case 0: {
                name = name + InternalSingleBucketAggregationTestCase.randomAlphaOfLength(5);
                break;
            }
            case 1: {
                docCount += (long)InternalSingleBucketAggregationTestCase.between(1, 2000);
                break;
            }
            case 2: {
                ArrayList<Object> aggs = new ArrayList<Object>();
                aggs.add(new InternalMax("new_max", InternalSingleBucketAggregationTestCase.randomDouble(), InternalSingleBucketAggregationTestCase.randomNumericDocValueFormat(), Collections.emptyMap()));
                aggs.add(new InternalMin("new_min", InternalSingleBucketAggregationTestCase.randomDouble(), InternalSingleBucketAggregationTestCase.randomNumericDocValueFormat(), Collections.emptyMap()));
                aggregations = InternalAggregations.from(aggs);
                break;
            }
            default: {
                metadata = metadata == null ? new HashMap<String, Object>(1) : new HashMap(instance.getMetadata());
                metadata.put(InternalSingleBucketAggregationTestCase.randomAlphaOfLength(15), InternalSingleBucketAggregationTestCase.randomInt());
            }
        }
        return this.createTestInstance(name, docCount, aggregations, metadata);
    }

    @Override
    protected final void assertReduced(T reduced, List<T> inputs) {
        double expected;
        InternalSingleBucketAggregationTestCase.assertEquals((long)inputs.stream().mapToLong(InternalSingleBucketAggregation::getDocCount).sum(), (long)reduced.getDocCount());
        if (this.hasInternalMax) {
            expected = inputs.stream().mapToDouble(i -> {
                InternalMax max = (InternalMax)i.getAggregations().get("max");
                return max.getValue();
            }).max().getAsDouble();
            InternalMax reducedMax = (InternalMax)reduced.getAggregations().get("max");
            InternalSingleBucketAggregationTestCase.assertEquals((double)expected, (double)reducedMax.getValue(), (double)0.0);
        }
        if (this.hasInternalMin) {
            expected = inputs.stream().mapToDouble(i -> {
                InternalMin min = (InternalMin)i.getAggregations().get("min");
                return min.getValue();
            }).min().getAsDouble();
            InternalMin reducedMin = (InternalMin)reduced.getAggregations().get("min");
            InternalSingleBucketAggregationTestCase.assertEquals((double)expected, (double)reducedMin.getValue(), (double)0.0);
        }
        this.extraAssertReduced(reduced, inputs);
    }

    @Override
    protected void assertFromXContent(T aggregation, ParsedAggregation parsedAggregation) throws IOException {
        InternalSingleBucketAggregationTestCase.assertTrue((boolean)(parsedAggregation instanceof ParsedSingleBucketAggregation));
        ParsedSingleBucketAggregation parsed = (ParsedSingleBucketAggregation)parsedAggregation;
        InternalSingleBucketAggregationTestCase.assertEquals((long)aggregation.getDocCount(), (long)parsed.getDocCount());
        InternalAggregations aggregations = aggregation.getAggregations();
        HashMap<String, Object> expectedAggregations = new HashMap<String, Object>();
        int expectedNumberOfAggregations = 0;
        for (Object expectedAggregation : aggregations) {
            InternalSingleBucketAggregationTestCase.assertTrue((boolean)(expectedAggregation instanceof InternalAggregation));
            expectedAggregations.put(expectedAggregation.getName(), expectedAggregation);
            ++expectedNumberOfAggregations;
        }
        int parsedNumberOfAggregations = 0;
        for (Aggregation parsedAgg : parsed.getAggregations()) {
            InternalSingleBucketAggregationTestCase.assertTrue((boolean)(parsedAgg instanceof ParsedAggregation));
            InternalSingleBucketAggregationTestCase.assertTrue((boolean)expectedAggregations.keySet().contains(parsedAgg.getName()));
            Aggregation expectedInternalAggregation = (Aggregation)expectedAggregations.get(parsedAgg.getName());
            XContentType xContentType = InternalSingleBucketAggregationTestCase.randomFrom(XContentType.values());
            ToXContent.MapParams params = new ToXContent.MapParams(Collections.singletonMap("typed_keys", "true"));
            BytesReference expectedBytes = XContentHelper.toXContent((ToXContent)expectedInternalAggregation, (XContentType)xContentType, (ToXContent.Params)params, (boolean)false);
            BytesReference actualBytes = XContentHelper.toXContent((ToXContent)parsedAgg, (XContentType)xContentType, (ToXContent.Params)params, (boolean)false);
            ElasticsearchAssertions.assertToXContentEquivalent(expectedBytes, actualBytes, xContentType);
            ++parsedNumberOfAggregations;
        }
        InternalSingleBucketAggregationTestCase.assertEquals((long)expectedNumberOfAggregations, (long)parsedNumberOfAggregations);
        Class<ParsedSingleBucketAggregation> parsedClass = this.implementationClass();
        InternalSingleBucketAggregationTestCase.assertTrue((parsedClass != null && parsedClass.isInstance(parsedAggregation) ? 1 : 0) != 0);
    }

    protected abstract Class<? extends ParsedSingleBucketAggregation> implementationClass();
}

