/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.collect.Set;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.lookup.SourceLookup;
import org.elasticsearch.test.ESTestCase;
import org.mockito.Mockito;

public abstract class FieldTypeTestCase
extends ESTestCase {
    public static final QueryShardContext MOCK_QSC = FieldTypeTestCase.createMockQueryShardContext(true);
    public static final QueryShardContext MOCK_QSC_DISALLOW_EXPENSIVE = FieldTypeTestCase.createMockQueryShardContext(false);

    protected QueryShardContext randomMockShardContext() {
        return FieldTypeTestCase.randomFrom(MOCK_QSC, MOCK_QSC_DISALLOW_EXPENSIVE);
    }

    static QueryShardContext createMockQueryShardContext(boolean allowExpensiveQueries) {
        QueryShardContext queryShardContext = (QueryShardContext)Mockito.mock(QueryShardContext.class);
        Mockito.when((Object)queryShardContext.allowExpensiveQueries()).thenReturn((Object)allowExpensiveQueries);
        return queryShardContext;
    }

    public static List<?> fetchSourceValue(MappedFieldType fieldType, Object sourceValue) throws IOException {
        return FieldTypeTestCase.fetchSourceValue(fieldType, sourceValue, null);
    }

    public static List<?> fetchSourceValue(MappedFieldType fieldType, Object sourceValue, String format) throws IOException {
        String field = fieldType.name();
        MapperService mapperService = (MapperService)Mockito.mock(MapperService.class);
        Mockito.when((Object)mapperService.sourcePath(field)).thenReturn((Object)Set.of((Object)field));
        ValueFetcher fetcher = fieldType.valueFetcher(mapperService, null, format);
        SourceLookup lookup = new SourceLookup();
        lookup.setSource(Collections.singletonMap(field, sourceValue));
        return fetcher.fetchValues(lookup);
    }
}

