/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import com.carrotsearch.randomizedtesting.RandomizedRunner;
import com.carrotsearch.randomizedtesting.RandomizedTest;
import java.io.InputStream;
import java.net.SocketPermission;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.LuceneTestCase;
import org.elasticsearch.bootstrap.Bootstrap;
import org.elasticsearch.bootstrap.BootstrapInfo;
import org.elasticsearch.bootstrap.BootstrapSettings;
import org.elasticsearch.bootstrap.ESPolicy;
import org.elasticsearch.bootstrap.FilePermissionUtils;
import org.elasticsearch.bootstrap.JarHell;
import org.elasticsearch.bootstrap.Security;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.network.IfConfig;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.secure_sm.SecureSM;
import org.junit.Assert;

public class BootstrapForTesting {
    private static void addClassCodebase(Map<String, URL> codebases, String name, String classname) {
        try {
            Class<?> clazz = BootstrapForTesting.class.getClassLoader().loadClass(classname);
            URL location = clazz.getProtectionDomain().getCodeSource().getLocation();
            if (!location.toString().endsWith(".jar") && codebases.put(name, location) != null) {
                throw new IllegalStateException("Already added " + name + " codebase for testing");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @SuppressForbidden(reason="accesses fully qualified URLs to configure security")
    static Map<String, Policy> getPluginPermissions() throws Exception {
        ArrayList<URL> pluginPolicies = Collections.list(BootstrapForTesting.class.getClassLoader().getResources("plugin-security.policy"));
        if (pluginPolicies.isEmpty()) {
            return Collections.emptyMap();
        }
        HashSet<URL> codebases = new HashSet<URL>(BootstrapForTesting.parseClassPathWithSymlinks());
        HashSet<URL> excluded = new HashSet<URL>(Arrays.asList(Bootstrap.class.getProtectionDomain().getCodeSource().getLocation(), BootstrapForTesting.class.getProtectionDomain().getCodeSource().getLocation(), LuceneTestCase.class.getProtectionDomain().getCodeSource().getLocation(), RandomizedRunner.class.getProtectionDomain().getCodeSource().getLocation(), Assert.class.getProtectionDomain().getCodeSource().getLocation()));
        codebases.removeAll(excluded);
        final ArrayList<Policy> policies = new ArrayList<Policy>(pluginPolicies.size());
        for (URL policyFile : pluginPolicies) {
            policies.add(Security.readPolicy((URL)policyFile, (Map)Security.getCodebaseJarMap(codebases)));
        }
        HashMap<String, 2> map = new HashMap<String, 2>();
        for (URL url : codebases) {
            map.put(url.getFile(), new Policy(){

                @Override
                public boolean implies(ProtectionDomain domain, Permission permission) {
                    for (Policy p : policies) {
                        if (!p.implies(domain, permission)) continue;
                        return true;
                    }
                    return false;
                }
            });
        }
        return Collections.unmodifiableMap(map);
    }

    @SuppressForbidden(reason="does evil stuff with paths and urls because devs and jenkins do evil stuff with paths and urls")
    static Set<URL> parseClassPathWithSymlinks() throws Exception {
        Set raw = JarHell.parseClassPath();
        HashSet<URL> cooked = new HashSet<URL>(raw.size());
        for (URL url : raw) {
            boolean added;
            Path path = PathUtils.get((URI)url.toURI());
            if (!Files.exists(path, new LinkOption[0]) || (added = cooked.add(path.toRealPath(new LinkOption[0]).toUri().toURL()))) continue;
            throw new IllegalStateException("Duplicate in classpath after resolving symlinks: " + url);
        }
        return raw;
    }

    public static void ensureInitialized() {
    }

    static {
        Path javaTmpDir = PathUtils.get((String)Objects.requireNonNull(System.getProperty("java.io.tmpdir"), "please set ${java.io.tmpdir} in pom.xml"), (String[])new String[0]);
        try {
            Security.ensureDirectoryExists((Path)javaTmpDir);
        }
        catch (Exception e) {
            throw new RuntimeException("unable to create test temp directory", e);
        }
        boolean memoryLock = (Boolean)BootstrapSettings.MEMORY_LOCK_SETTING.get(Settings.EMPTY);
        boolean systemCallFilter = Booleans.parseBoolean((String)System.getProperty("tests.system_call_filter", "true"));
        Bootstrap.initializeNatives((Path)javaTmpDir, (boolean)memoryLock, (boolean)systemCallFilter, (boolean)true);
        Bootstrap.initializeProbes();
        BootstrapInfo.getSystemProperties();
        try {
            Logger logger = LogManager.getLogger(JarHell.class);
            JarHell.checkJarHell(arg_0 -> ((Logger)logger).debug(arg_0));
        }
        catch (Exception e) {
            throw new RuntimeException("found jar hell in test classpath", e);
        }
        IfConfig.logIfNecessary();
        if (RandomizedTest.systemPropertyAsBoolean((String)"tests.security.manager", (boolean)true)) {
            try {
                boolean testsCoverage;
                Permissions perms = new Permissions();
                Security.addClasspathPermissions((Permissions)perms);
                FilePermissionUtils.addDirectoryPath((Permissions)perms, (String)"java.io.tmpdir", (Path)javaTmpDir, (String)"read,readlink,write,delete", (boolean)false);
                if (Strings.hasLength((String)System.getProperty("tests.config"))) {
                    FilePermissionUtils.addSingleFilePath((Permissions)perms, (Path)PathUtils.get((String)System.getProperty("tests.config"), (String[])new String[0]), (String)"read,readlink");
                }
                if (testsCoverage = Booleans.parseBoolean((String)System.getProperty("tests.coverage", "false"))) {
                    Path coverageDir = PathUtils.get((String)System.getProperty("tests.coverage.dir"), (String[])new String[0]);
                    FilePermissionUtils.addSingleFilePath((Permissions)perms, (Path)coverageDir.resolve("jacoco.exec"), (String)"read,write");
                    FilePermissionUtils.addSingleFilePath((Permissions)perms, (Path)coverageDir.resolve("jacoco-it.exec"), (String)"read,write");
                }
                if (System.getProperty("tests.gradle") == null) {
                    perms.add(new RuntimePermission("setIO"));
                }
                perms.add(new SocketPermission("localhost:0", "listen,resolve"));
                perms.add(new SocketPermission("localhost:1024-", "listen,resolve"));
                Map codebases = Security.getCodebaseJarMap((Set)JarHell.parseClassPath());
                BootstrapForTesting.addClassCodebase(codebases, "elasticsearch", "org.elasticsearch.plugins.PluginsService");
                if (System.getProperty("tests.gradle") == null) {
                    BootstrapForTesting.addClassCodebase(codebases, "plugin-classloader", "org.elasticsearch.plugins.ExtendedPluginsClassLoader");
                    BootstrapForTesting.addClassCodebase(codebases, "elasticsearch-nio", "org.elasticsearch.nio.ChannelFactory");
                    BootstrapForTesting.addClassCodebase(codebases, "elasticsearch-secure-sm", "org.elasticsearch.secure_sm.SecureSM");
                    BootstrapForTesting.addClassCodebase(codebases, "elasticsearch-rest-client", "org.elasticsearch.client.RestClient");
                }
                Policy testFramework = Security.readPolicy((URL)Bootstrap.class.getResource("test-framework.policy"), (Map)codebases);
                ESPolicy esPolicy = new ESPolicy(codebases, (PermissionCollection)perms, BootstrapForTesting.getPluginPermissions(), true, (PermissionCollection)new Permissions());
                Policy.setPolicy(new Policy((Policy)esPolicy, testFramework){
                    final /* synthetic */ Policy val$esPolicy;
                    final /* synthetic */ Policy val$testFramework;
                    {
                        this.val$esPolicy = policy;
                        this.val$testFramework = policy2;
                    }

                    @Override
                    public boolean implies(ProtectionDomain domain, Permission permission) {
                        return this.val$esPolicy.implies(domain, permission) || this.val$testFramework.implies(domain, permission);
                    }
                });
                System.setSecurityManager((SecurityManager)SecureSM.createTestSecureSM());
                Security.selfTest();
                for (URL url : Collections.list(BootstrapForTesting.class.getClassLoader().getResources("plugin-descriptor.properties"))) {
                    Properties properties = new Properties();
                    try (InputStream stream = FileSystemUtils.openFileURLStream((URL)url);){
                        properties.load(stream);
                    }
                    String clazz = properties.getProperty("classname");
                    if (clazz == null) continue;
                    Class.forName(clazz);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("unable to install test security manager", e);
            }
        }
    }
}

