/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.matrix;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public abstract class ArrayValuesSourceAggregatorFactory
extends AggregatorFactory {
    protected Map<String, ValuesSourceConfig> configs;

    public ArrayValuesSourceAggregatorFactory(String name, Map<String, ValuesSourceConfig> configs, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, subFactoriesBuilder, metadata);
        this.configs = configs;
    }

    public Aggregator createInternal(Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        HashMap<String, ValuesSource> valuesSources = new HashMap<String, ValuesSource>();
        for (Map.Entry<String, ValuesSourceConfig> config : this.configs.entrySet()) {
            ValuesSourceConfig vsc = config.getValue();
            if (!vsc.hasValues()) continue;
            valuesSources.put(config.getKey(), vsc.getValuesSource());
        }
        if (valuesSources.isEmpty()) {
            return this.createUnmapped(parent, metadata);
        }
        return this.doCreateInternal(valuesSources, parent, cardinality, metadata);
    }

    protected abstract Aggregator createUnmapped(Aggregator var1, Map<String, Object> var2) throws IOException;

    protected abstract Aggregator doCreateInternal(Map<String, ValuesSource> var1, Aggregator var2, CardinalityUpperBound var3, Map<String, Object> var4) throws IOException;
}

