/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.mocksocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;

public final class PrivilegedSocketAccess {
    private PrivilegedSocketAccess() {
    }

    public static SocketChannel accept(ServerSocketChannel serverSocketChannel) throws IOException {
        try {
            return AccessController.doPrivileged(serverSocketChannel::accept);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static boolean connect(SocketChannel socketChannel, InetSocketAddress remoteAddress) throws IOException {
        try {
            return AccessController.doPrivileged(() -> socketChannel.connect(remoteAddress));
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }
}

