/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.handler.impl.elasticsearch;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.cfg.CompositeSettings;
import org.elasticsearch.hadoop.cfg.PropertiesSettings;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.handler.ErrorCollector;
import org.elasticsearch.hadoop.handler.ErrorHandler;
import org.elasticsearch.hadoop.handler.Exceptional;
import org.elasticsearch.hadoop.handler.HandlerResult;
import org.elasticsearch.hadoop.handler.impl.elasticsearch.EventConverter;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.hadoop.rest.Resource;
import org.elasticsearch.hadoop.rest.RestClient;
import org.elasticsearch.hadoop.rest.RestRepository;
import org.elasticsearch.hadoop.rest.RestService;
import org.elasticsearch.hadoop.serialization.field.IndexExtractor;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.ObjectUtils;
import org.elasticsearch.hadoop.util.SettingsUtils;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.hadoop.util.ecs.ElasticCommonSchema;
import org.elasticsearch.hadoop.util.ecs.MessageTemplate;
import org.elasticsearch.hadoop.util.unit.Booleans;

public class ElasticsearchHandler<I extends Exceptional, O, C extends ErrorCollector<O>>
implements ErrorHandler<I, O, C> {
    private static final Log LOG = LogFactory.getLog(ElasticsearchHandler.class);
    private static final String CONST_EVENT_CATEGORY = "error";
    public static final String CONF_RETURN_VALUE = "return.default";
    public static final String CONF_RETURN_VALUE_DEFAULT = HandlerResult.HANDLED.toString();
    public static final String CONF_RETURN_ERROR = "return.error";
    public static final String CONF_RETURN_ERROR_DEFAULT = HandlerResult.ABORT.toString();
    public static final String CONF_PASS_REASON_SUFFIX = "reason";
    public static final String CONF_LABEL = "label";
    public static final String CONF_TAGS = "tags";
    public static final String CONF_CLIENT_NODES = "client.nodes";
    public static final String CONF_CLIENT_PORT = "client.port";
    public static final String CONF_CLIENT_RESOURCE = "client.resource";
    public static final String CONF_CLIENT_INHERIT = "client.inherit";
    public static final String CONF_CLIENT_CONF = "client.conf";
    private HandlerResult returnDefault;
    private String successReason;
    private HandlerResult returnError;
    private String errorReason;
    private Settings rootSettings;
    private Settings clientSettings;
    private EventConverter<I> eventConverter;
    private MessageTemplate messageTemplate;
    private boolean initialized;
    private Resource endpoint;
    private RestRepository writeClient;

    public static <I extends Exceptional, O, C extends ErrorCollector<O>> ElasticsearchHandler<I, O, C> create(Settings rootSettings, EventConverter<I> converter) {
        return new ElasticsearchHandler<I, O, C>(rootSettings, converter);
    }

    public ElasticsearchHandler(Settings rootSettings, EventConverter<I> eventConverter) {
        this.rootSettings = rootSettings;
        this.eventConverter = eventConverter;
    }

    @Override
    public void init(Properties properties) {
        PropertiesSettings handlerSettings = new PropertiesSettings(properties);
        boolean inheritRoot = true;
        if (((Settings)handlerSettings).getProperty(CONF_CLIENT_INHERIT) != null) {
            inheritRoot = Booleans.parseBoolean(((Settings)handlerSettings).getProperty(CONF_CLIENT_INHERIT));
        }
        if (SettingsUtils.hasJobTransportPoolingKey(this.rootSettings)) {
            String jobKey = SettingsUtils.getJobTransportPoolingKey(this.rootSettings);
            String newJobKey = jobKey + "_" + UUID.randomUUID().toString();
            ((Settings)handlerSettings).setProperty("client.conf.es.internal.transport.pooling.key", newJobKey);
        }
        this.resolveProperty(CONF_CLIENT_NODES, "client.conf.es.nodes", handlerSettings);
        this.resolveProperty(CONF_CLIENT_PORT, "client.conf.es.port", handlerSettings);
        this.resolveProperty(CONF_CLIENT_RESOURCE, "client.conf.es.resource.write", handlerSettings);
        this.resolveProperty(CONF_CLIENT_RESOURCE, "client.conf.es.resource", handlerSettings);
        this.clientSettings = handlerSettings.getSettingsView(CONF_CLIENT_CONF);
        Assert.hasText(this.clientSettings.getResourceWrite(), "Could not locate write resource for ES error handler.");
        if (inheritRoot) {
            LOG.info((Object)"Elasticsearch Error Handler inheriting root configuration");
            this.clientSettings = new CompositeSettings(Arrays.asList(this.clientSettings, this.rootSettings.excludeFilter("es.internal")));
        } else {
            LOG.info((Object)"Elasticsearch Error Handler proceeding without inheriting root configuration options as configured");
        }
        InitializationUtils.discoverAndValidateClusterInfo(this.clientSettings, LOG);
        Resource resource = new Resource(this.clientSettings, false);
        IndexExtractor iformat = (IndexExtractor)ObjectUtils.instantiate(this.clientSettings.getMappingIndexExtractorClassName(), handlerSettings);
        iformat.compile(resource.toString());
        if (iformat.hasPattern()) {
            throw new IllegalArgumentException(String.format("Cannot use index format within Elasticsearch Error Handler. Format was [%s]", resource.toString()));
        }
        this.endpoint = resource;
        ElasticCommonSchema schema = new ElasticCommonSchema();
        ElasticCommonSchema.TemplateBuilder templateBuilder = schema.buildTemplate().setEventCategory(CONST_EVENT_CATEGORY);
        for (Map.Entry<Object, Object> entry : handlerSettings.getSettingsView(CONF_LABEL).asProperties().entrySet()) {
            templateBuilder.addLabel(entry.getKey().toString(), entry.getValue().toString());
        }
        templateBuilder.addTags(StringUtils.tokenize(((Settings)handlerSettings).getProperty(CONF_TAGS)));
        templateBuilder = this.eventConverter.configureTemplate(templateBuilder);
        this.messageTemplate = templateBuilder.build();
        this.returnDefault = HandlerResult.valueOf(handlerSettings.getProperty(CONF_RETURN_VALUE, CONF_RETURN_VALUE_DEFAULT));
        this.successReason = HandlerResult.PASS == this.returnDefault ? ((Settings)handlerSettings).getProperty("return.default.reason") : null;
        this.returnError = HandlerResult.valueOf(handlerSettings.getProperty(CONF_RETURN_ERROR, CONF_RETURN_ERROR_DEFAULT));
        this.errorReason = HandlerResult.PASS == this.returnError ? ((Settings)handlerSettings).getProperty("return.error.reason") : null;
    }

    private void resolveProperty(String highLevelProperty, String explicitProperty, Settings subject) {
        String confValue = subject.getProperty(highLevelProperty);
        String explicitValue = subject.getProperty(explicitProperty);
        if (StringUtils.hasText(confValue) && StringUtils.hasText(explicitValue)) {
            LOG.warn((Object)String.format("Found both [%s] and [%s] settings during elasticsearch handler init. Continuing with value from [%s] (%s)", highLevelProperty, explicitProperty, highLevelProperty, confValue));
        }
        if (StringUtils.hasText(confValue)) {
            subject.setProperty(explicitProperty, confValue);
        }
    }

    private void lazyInitWrite() {
        if (!this.initialized) {
            this.initialized = true;
            this.writeClient = RestService.createWriter((Settings)this.clientSettings, (long)-1L, (int)0, (Log)ElasticsearchHandler.LOG).repository;
        }
    }

    @Override
    public HandlerResult onError(I entry, C collector) throws Exception {
        HandlerResult result;
        try {
            this.lazyInitWrite();
            if (this.isOpen()) {
                this.putDocument(this.writeClient.getRestClient(), this.createErrorDocument(entry));
                result = this.generateResult(this.returnDefault, this.successReason, collector);
            } else {
                result = this.generateResult(this.returnError, this.errorReason, collector);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Could not send error handling data to ES", (Throwable)e);
            result = this.generateResult(this.returnError, this.errorReason, collector);
        }
        return result;
    }

    private boolean isOpen() {
        return this.writeClient != null;
    }

    private BytesArray createErrorDocument(I entry) throws IOException {
        return this.eventConverter.generateEvent(entry, this.messageTemplate);
    }

    private void putDocument(RestClient client, BytesArray document) throws IOException {
        client.postDocument(this.endpoint, document);
    }

    private HandlerResult generateResult(HandlerResult expectedResult, String possiblePassReason, C collector) {
        if (HandlerResult.PASS == expectedResult) {
            return collector.pass(possiblePassReason);
        }
        return expectedResult;
    }

    @Override
    public void close() {
        if (this.isOpen()) {
            if (this.clientSettings.getBatchRefreshAfterWrite()) {
                this.writeClient.getRestClient().refresh(this.endpoint);
            }
            this.writeClient.close();
        }
    }
}

