/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.handler.impl;

import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.handler.ErrorCollector;
import org.elasticsearch.hadoop.handler.ErrorHandler;
import org.elasticsearch.hadoop.handler.Exceptional;
import org.elasticsearch.hadoop.handler.HandlerResult;
import org.elasticsearch.hadoop.handler.impl.LogRenderer;

public class DropAndLog<I extends Exceptional, O, C extends ErrorCollector<O>>
implements ErrorHandler<I, O, C> {
    public static final String CONF_LOGGER_NAME = "logger.name";
    public static final String CONF_LOGGER_CLASS = "logger.class";
    public static final String CONF_LOGGER_LEVEL = "logger.level";
    private Log logger;
    private LogLevel loggerLevel;
    private final LogRenderer<I> logLineMaker;

    public static <I extends Exceptional, O, C extends ErrorCollector<O>> DropAndLog<I, O, C> create(LogRenderer<I> logLineMaker) {
        return new DropAndLog<I, O, C>(logLineMaker);
    }

    public DropAndLog(LogRenderer<I> logLineMaker) {
        this.logLineMaker = logLineMaker;
    }

    @Override
    public void init(Properties properties) {
        Class<?> loggerClass;
        String loggerName = properties.getProperty(CONF_LOGGER_NAME);
        String loggerClassName = properties.getProperty(CONF_LOGGER_CLASS);
        if (loggerClassName != null) {
            try {
                loggerClass = Class.forName(loggerClassName);
            }
            catch (ClassNotFoundException cnfe) {
                throw new EsHadoopIllegalArgumentException("Could not locate logger class [" + loggerClassName + "].", cnfe);
            }
        } else {
            loggerClass = null;
        }
        if (loggerName != null && loggerClass != null) {
            throw new EsHadoopIllegalArgumentException("Both logger name and logger class provided for drop and log handler. Provide only one. Bailing out...");
        }
        if (loggerName != null) {
            this.logger = LogFactory.getLog((String)loggerName);
        } else if (loggerClass != null) {
            this.logger = LogFactory.getLog(loggerClass);
        } else {
            throw new EsHadoopIllegalArgumentException("No logger name or logger class provided for drop and log handler. Provide one. Bailing out...");
        }
        String rawLoggerLevel = properties.getProperty(CONF_LOGGER_LEVEL, LogLevel.WARN.name());
        if (!LogLevel.names.contains(rawLoggerLevel)) {
            throw new EsHadoopIllegalArgumentException("Invalid logger level [" + rawLoggerLevel + "] given. Available logging levels: " + LogLevel.names.toString());
        }
        this.loggerLevel = LogLevel.valueOf(rawLoggerLevel);
    }

    @Override
    public HandlerResult onError(I entry, C collector) throws Exception {
        switch (this.loggerLevel) {
            case FATAL: {
                if (!this.logger.isFatalEnabled()) break;
                this.logger.fatal((Object)this.logLineMaker.renderLog(entry), (Throwable)entry.getException());
                break;
            }
            case ERROR: {
                if (!this.logger.isErrorEnabled()) break;
                this.logger.error((Object)this.logLineMaker.renderLog(entry), (Throwable)entry.getException());
                break;
            }
            case WARN: {
                if (!this.logger.isWarnEnabled()) break;
                this.logger.warn((Object)this.logLineMaker.renderLog(entry), (Throwable)entry.getException());
                break;
            }
            case INFO: {
                if (!this.logger.isInfoEnabled()) break;
                this.logger.info((Object)this.logLineMaker.renderLog(entry), (Throwable)entry.getException());
                break;
            }
            case DEBUG: {
                if (!this.logger.isDebugEnabled()) break;
                this.logger.debug((Object)this.logLineMaker.renderLog(entry), (Throwable)entry.getException());
                break;
            }
            case TRACE: {
                if (!this.logger.isTraceEnabled()) break;
                this.logger.trace((Object)this.logLineMaker.renderLog(entry), (Throwable)entry.getException());
            }
        }
        return HandlerResult.HANDLED;
    }

    @Override
    public void close() {
    }

    private static enum LogLevel {
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

        private static Set<String> names;

        static {
            names = new LinkedHashSet<String>();
            for (LogLevel logLevel : LogLevel.values()) {
                names.add(logLevel.name());
            }
        }
    }
}

