/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.sql.streaming;

import org.apache.spark.TaskContext;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.types.StructType;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.serialization.BytesConverter;
import org.elasticsearch.hadoop.serialization.JdkBytesConverter;
import org.elasticsearch.hadoop.serialization.builder.ValueWriter;
import org.elasticsearch.hadoop.serialization.field.FieldExtractor;
import org.elasticsearch.spark.rdd.EsRDDWriter;
import org.elasticsearch.spark.rdd.EsRDDWriter$;
import org.elasticsearch.spark.sql.DataFrameFieldExtractor;
import org.elasticsearch.spark.sql.DataFrameValueWriter;
import org.elasticsearch.spark.sql.streaming.EsCommitProtocol;
import org.elasticsearch.spark.sql.streaming.TaskCommit;
import org.elasticsearch.spark.sql.streaming.TaskState;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%d!B\u0007\u000f\u0001AA\u0002\"C\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u00169\u0011!I\u0004A!A!\u0002\u0013Q\u0004\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011B!\t\u000b\u0015\u0003A\u0011\u0001$\t\u000b-\u0003A\u0011\u000b'\t\u000b5\u0004A\u0011\u000b8\t\u000be\u0004A\u0011\u000b>\t\u0013\u0005=\u0001A1A\u0005\n\u0005E\u0001\u0002CA\u0014\u0001\u0001\u0006I!a\u0005\t\u000f\u0005%\u0002\u0001\"\u0011\u0002,!9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0003bBA2\u0001\u0011E\u0013Q\r\u0002\u0014\u000bN\u001cFO]3b[F+XM]=Xe&$XM\u001d\u0006\u0003\u001fA\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005E\u0011\u0012aA:rY*\u00111\u0003F\u0001\u0006gB\f'o\u001b\u0006\u0003+Y\tQ\"\u001a7bgRL7m]3be\u000eD'\"A\f\u0002\u0007=\u0014xm\u0005\u0002\u00013A\u0019!$H\u0010\u000e\u0003mQ!\u0001\b\n\u0002\u0007I$G-\u0003\u0002\u001f7\tYQi\u001d*E\t^\u0013\u0018\u000e^3s!\t\u0001s%D\u0001\"\u0015\t\u00113%\u0001\u0005dCR\fG._:u\u0015\t\tBE\u0003\u0002\u0014K)\u0011aEF\u0001\u0007CB\f7\r[3\n\u0005!\n#aC%oi\u0016\u0014h.\u00197S_^\f!c]3sS\u0006d\u0017N_3e'\u0016$H/\u001b8hg\u000e\u0001\u0001C\u0001\u00176\u001d\ti3\u0007\u0005\u0002/c5\tqF\u0003\u00021U\u00051AH]8pizR\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\na\u0001\u0015:fI\u00164\u0017B\u0001\u001c8\u0005\u0019\u0019FO]5oO*\u0011A'M\u0005\u0003Su\taa]2iK6\f\u0007CA\u001e?\u001b\u0005a$BA\u001f$\u0003\u0015!\u0018\u0010]3t\u0013\tyDH\u0001\u0006TiJ,8\r\u001e+za\u0016\fabY8n[&$\bK]8u_\u000e|G\u000e\u0005\u0002C\u00076\ta\"\u0003\u0002E\u001d\t\u0001Ri]\"p[6LG\u000f\u0015:pi>\u001cw\u000e\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u001dC\u0015J\u0013\t\u0003\u0005\u0002AQ!\u000b\u0003A\u0002-BQ!\u000f\u0003A\u0002iBQ\u0001\u0011\u0003A\u0002\u0005\u000b1B^1mk\u0016<&/\u001b;feV\tQ\n\r\u0002O'B\u0019AfT)\n\u0005A;$!B\"mCN\u001c\bC\u0001*T\u0019\u0001!\u0011\u0002V\u0003\u0002\u0002\u0003\u0005)\u0011A+\u0003\u0007}#\u0013'\u0005\u0002W5B\u0011q\u000bW\u0007\u0002c%\u0011\u0011,\r\u0002\b\u001d>$\b.\u001b8ha\tYf\rE\u0002]G\u0016l\u0011!\u0018\u0006\u0003=~\u000bqAY;jY\u0012,'O\u0003\u0002aC\u0006i1/\u001a:jC2L'0\u0019;j_:T!A\u0019\u000b\u0002\r!\fGm\\8q\u0013\t!WLA\u0006WC2,Xm\u0016:ji\u0016\u0014\bC\u0001*g\t%9\u0007.!A\u0001\u0002\u000b\u0005\u0011NA\u0002`II\"\u0011\u0002V\u0003\u0002\u0002\u0007\u0005)\u0011A+\u0012\u0005YS\u0007CA,l\u0013\ta\u0017GA\u0002B]f\faBY=uKN\u001cuN\u001c<feR,'/F\u0001pa\t\u0001(\u000fE\u0002-\u001fF\u0004\"A\u0015:\u0005\u0013M4\u0011\u0011!A\u0001\u0006\u0003!(aA0%gE\u0011a+\u001e\t\u0003m^l\u0011aX\u0005\u0003q~\u0013aBQ=uKN\u001cuN\u001c<feR,'/\u0001\bgS\u0016dG-\u0012=ue\u0006\u001cGo\u001c:\u0016\u0003m\u0004$\u0001 @\u0011\u00071zU\u0010\u0005\u0002S}\u0012QqpBA\u0001\u0002\u0003\u0015\t!!\u0001\u0003\u0007}#C'E\u0002W\u0003\u0007\u0001B!!\u0002\u0002\f5\u0011\u0011q\u0001\u0006\u0004\u0003\u0013y\u0016!\u00024jK2$\u0017\u0002BA\u0007\u0003\u000f\u0011aBR5fY\u0012,\u0005\u0010\u001e:bGR|'/A\u0004f]\u000e|G-\u001a:\u0016\u0005\u0005M\u0001CBA\u000b\u00037\ty\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011D\u0011\u0002\u0011\u0015t7m\u001c3feNLA!!\b\u0002\u0018\t\tR\t\u001f9sKN\u001c\u0018n\u001c8F]\u000e|G-\u001a:\u0011\t\u0005\u0005\u00121E\u0007\u0002G%\u0019\u0011QE\u0012\u0003\u0007I{w/\u0001\u0005f]\u000e|G-\u001a:!\u0003\u00159(/\u001b;f)\u0019\ti#a\r\u0002@A\u0019q+a\f\n\u0007\u0005E\u0012G\u0001\u0003V]&$\bbBA\u001b\u0015\u0001\u0007\u0011qG\u0001\fi\u0006\u001c8nQ8oi\u0016DH\u000f\u0005\u0003\u0002:\u0005mR\"\u0001\u0013\n\u0007\u0005uBEA\u0006UCN\\7i\u001c8uKb$\bbBA!\u0015\u0001\u0007\u00111I\u0001\u0005I\u0006$\u0018\rE\u0003\u0002F\u0005=sD\u0004\u0003\u0002H\u0005-cb\u0001\u0018\u0002J%\t!'C\u0002\u0002NE\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002R\u0005M#\u0001C%uKJ\fGo\u001c:\u000b\u0007\u00055\u0013'A\u0002sk:$b!!\u0017\u0002`\u0005\u0005\u0004c\u0001\"\u0002\\%\u0019\u0011Q\f\b\u0003\u0015Q\u000b7o[\"p[6LG\u000fC\u0004\u00026-\u0001\r!a\u000e\t\u000f\u0005\u00053\u00021\u0001\u0002D\u0005Y\u0001O]8dKN\u001cH)\u0019;b)\rQ\u0017q\r\u0005\b\u0003\u0003b\u0001\u0019AA\"\u0001")
public class EsStreamQueryWriter
extends EsRDDWriter<InternalRow> {
    private final StructType schema;
    private final EsCommitProtocol commitProtocol;
    private final ExpressionEncoder<Row> encoder;

    @Override
    public Class<? extends ValueWriter<?>> valueWriter() {
        return DataFrameValueWriter.class;
    }

    @Override
    public Class<? extends BytesConverter> bytesConverter() {
        return JdkBytesConverter.class;
    }

    @Override
    public Class<? extends FieldExtractor> fieldExtractor() {
        return DataFrameFieldExtractor.class;
    }

    private ExpressionEncoder<Row> encoder() {
        return this.encoder;
    }

    @Override
    public void write(TaskContext taskContext, Iterator<InternalRow> data) {
        throw new EsHadoopIllegalArgumentException("Use run(taskContext, data) instead to retrieve the commit information");
    }

    public TaskCommit run(TaskContext taskContext, Iterator<InternalRow> data) {
        TaskState taskInfo = new TaskState(taskContext.partitionId(), this.settings().getResourceWrite());
        this.commitProtocol.initTask(taskInfo);
        try {
            super.write(taskContext, data);
        }
        catch (Throwable t) {
            this.commitProtocol.abortTask(taskInfo);
            throw t;
        }
        return this.commitProtocol.commitTask(taskInfo);
    }

    @Override
    public Object processData(Iterator<InternalRow> data) {
        Row row = (Row)this.encoder().fromRow((InternalRow)data.next());
        this.commitProtocol.recordSeen();
        return new Tuple2((Object)row, (Object)this.schema);
    }

    public EsStreamQueryWriter(String serializedSettings, StructType schema, EsCommitProtocol commitProtocol) {
        this.schema = schema;
        this.commitProtocol = commitProtocol;
        super(serializedSettings, EsRDDWriter$.MODULE$.$lessinit$greater$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        ExpressionEncoder qual$1 = RowEncoder$.MODULE$.apply(schema);
        Seq x$1 = qual$1.resolveAndBind$default$1();
        Analyzer x$2 = qual$1.resolveAndBind$default$2();
        this.encoder = qual$1.resolveAndBind(x$1, x$2);
    }
}

