/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.util;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class FieldAlias {
    private final Map<String, String> fieldToAlias;
    private final boolean caseInsensitive;

    public FieldAlias(boolean caseInsensitive) {
        this(new LinkedHashMap<String, String>(), caseInsensitive);
    }

    public FieldAlias(Map<String, String> alias, boolean caseInsensitive) {
        this.fieldToAlias = alias;
        this.caseInsensitive = caseInsensitive;
    }

    public String toES(String string) {
        String alias = this.fieldToAlias.get(string);
        if (alias == null) {
            alias = this.caseInsensitive ? string.toLowerCase(Locale.ROOT) : string;
            this.fieldToAlias.put(string, alias);
        }
        return alias;
    }

    public String toString() {
        return this.fieldToAlias.toString();
    }
}

