/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.dto.mapping;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.serialization.FieldType;
import org.elasticsearch.hadoop.serialization.dto.mapping.Field;
import org.elasticsearch.hadoop.serialization.dto.mapping.MappingSet;

public final class FieldParser {
    private FieldParser() {
    }

    public static MappingSet parseMapping(Map<String, Object> content) {
        Iterator<Map.Entry<String, Object>> iterator = content.entrySet().iterator();
        ArrayList<Field> fields = new ArrayList<Field>();
        while (iterator.hasNext()) {
            Field field = FieldParser.parseField(iterator.next(), null);
            fields.add(field);
        }
        return new MappingSet(fields);
    }

    private static Field skipHeaders(Field field) {
        Field[] props = field.properties();
        if (props.length > 0 && props[0] != null && "mappings".equals(props[0].name()) && FieldType.OBJECT.equals((Object)props[0].type())) {
            return props[0].properties()[0];
        }
        return field;
    }

    private static Field parseField(Map.Entry<String, Object> entry, String previousKey) {
        String key = entry.getKey();
        Object value = entry.getValue();
        if (value instanceof Map) {
            Map content = (Map)value;
            FieldType fieldType = FieldType.OBJECT;
            Object type = content.get("type");
            if (type instanceof String) {
                fieldType = FieldType.parse(type.toString());
                if (FieldType.isRelevant(fieldType)) {
                    if (!FieldType.isCompound(fieldType)) {
                        return new Field(key, fieldType);
                    }
                } else {
                    return null;
                }
            }
            if (FieldType.JOIN == fieldType) {
                return new Field(key, fieldType, new Field[]{new Field("name", FieldType.KEYWORD), new Field("parent", FieldType.KEYWORD)});
            }
            ArrayList<Field> fields = new ArrayList<Field>(content.size());
            for (Map.Entry<String, Object> entry2 : content.entrySet()) {
                if (!(entry2.getValue() instanceof Map)) continue;
                Field fl = FieldParser.parseField(entry2, key);
                if (fl != null && fl.type() == FieldType.OBJECT && "properties".equals(fl.name()) && !FieldParser.isFieldNamedProperties(entry2.getValue())) {
                    return new Field(key, fieldType, fl.properties());
                }
                if (fl == null) continue;
                fields.add(fl);
            }
            return new Field(key, fieldType, fields);
        }
        throw new EsHadoopIllegalArgumentException("invalid map received " + entry);
    }

    private static boolean isFieldNamedProperties(Object fieldValue) {
        Map fieldValueAsMap;
        return fieldValue instanceof Map && ((fieldValueAsMap = (Map)fieldValue).containsKey("type") && fieldValueAsMap.get("type") instanceof String || fieldValueAsMap.containsKey("properties") && !FieldParser.isFieldNamedProperties(fieldValueAsMap.get("properties")));
    }
}

