/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization;

import java.util.List;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.handler.HandlerLoader;
import org.elasticsearch.hadoop.handler.impl.PreloadedHandlerLoader;
import org.elasticsearch.hadoop.serialization.builder.ValueReader;
import org.elasticsearch.hadoop.serialization.dto.mapping.Mapping;
import org.elasticsearch.hadoop.serialization.handler.read.IDeserializationErrorHandler;
import org.elasticsearch.hadoop.serialization.handler.read.impl.DeserializationHandlerLoader;
import org.elasticsearch.hadoop.util.StringUtils;

public class ScrollReaderConfigBuilder {
    private final ValueReader reader;
    private boolean returnRawJson;
    private Mapping resolvedMapping;
    private boolean ignoreUnmappedFields;
    private boolean readMetadata;
    private String metadataName;
    private List<String> includeFields;
    private List<String> excludeFields;
    private List<String> includeArrayFields;
    private HandlerLoader<IDeserializationErrorHandler> errorHandlerLoader;

    public static ScrollReaderConfigBuilder builder(ValueReader reader, Mapping resolvedMapping, Settings cfg) {
        return ScrollReaderConfigBuilder.builder(reader, cfg).setResolvedMapping(resolvedMapping);
    }

    public static ScrollReaderConfigBuilder builder(ValueReader reader, Settings settings) {
        return new ScrollReaderConfigBuilder(settings, reader);
    }

    public ScrollReaderConfigBuilder(Settings settings, ValueReader reader) {
        this.reader = reader;
        this.returnRawJson = settings.getOutputAsJson();
        this.ignoreUnmappedFields = settings.getReadMappingMissingFieldsIgnore();
        this.readMetadata = settings.getReadMetadata();
        this.metadataName = settings.getReadMetadataField();
        this.includeFields = StringUtils.tokenize(settings.getReadFieldInclude());
        this.excludeFields = StringUtils.tokenize(settings.getReadFieldExclude());
        this.includeArrayFields = StringUtils.tokenize(settings.getReadFieldAsArrayInclude());
        DeserializationHandlerLoader loader = new DeserializationHandlerLoader();
        loader.setSettings(settings);
        this.errorHandlerLoader = loader;
        this.resolvedMapping = null;
    }

    public ValueReader getReader() {
        return this.reader;
    }

    public boolean getReturnRawJson() {
        return this.returnRawJson;
    }

    public ScrollReaderConfigBuilder setReturnRawJson(boolean returnRawJson) {
        this.returnRawJson = returnRawJson;
        return this;
    }

    public Mapping getResolvedMapping() {
        return this.resolvedMapping;
    }

    public ScrollReaderConfigBuilder setResolvedMapping(Mapping resolvedMapping) {
        this.resolvedMapping = resolvedMapping;
        return this;
    }

    public boolean getIgnoreUnmappedFields() {
        return this.ignoreUnmappedFields;
    }

    public ScrollReaderConfigBuilder setIgnoreUnmappedFields(boolean ignoreUnmappedFields) {
        this.ignoreUnmappedFields = ignoreUnmappedFields;
        return this;
    }

    public boolean getReadMetadata() {
        return this.readMetadata;
    }

    public ScrollReaderConfigBuilder setReadMetadata(boolean readMetadata) {
        this.readMetadata = readMetadata;
        return this;
    }

    public String getMetadataName() {
        return this.metadataName;
    }

    public ScrollReaderConfigBuilder setMetadataName(String metadataName) {
        this.metadataName = metadataName;
        return this;
    }

    public List<String> getIncludeFields() {
        return this.includeFields;
    }

    public ScrollReaderConfigBuilder setIncludeFields(List<String> includeFields) {
        this.includeFields = includeFields;
        return this;
    }

    public List<String> getExcludeFields() {
        return this.excludeFields;
    }

    public ScrollReaderConfigBuilder setExcludeFields(List<String> excludeFields) {
        this.excludeFields = excludeFields;
        return this;
    }

    public List<String> getIncludeArrayFields() {
        return this.includeArrayFields;
    }

    public ScrollReaderConfigBuilder setIncludeArrayFields(List<String> includeArrayFields) {
        this.includeArrayFields = includeArrayFields;
        return this;
    }

    public HandlerLoader<IDeserializationErrorHandler> getErrorHandlerLoader() {
        return this.errorHandlerLoader;
    }

    public ScrollReaderConfigBuilder setErrorHandlerLoader(HandlerLoader<IDeserializationErrorHandler> errorHandlerLoader) {
        this.errorHandlerLoader = errorHandlerLoader;
        return this;
    }

    public ScrollReaderConfigBuilder setErrorHandlers(List<IDeserializationErrorHandler> errorHandlers) {
        this.errorHandlerLoader = new PreloadedHandlerLoader<IDeserializationErrorHandler>(errorHandlers);
        return this;
    }
}

