/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.storm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.Fields;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.hadoop.rest.PartitionDefinition;
import org.elasticsearch.hadoop.rest.RestService;
import org.elasticsearch.hadoop.security.JdkUserProvider;
import org.elasticsearch.hadoop.serialization.builder.JdkValueReader;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.storm.cfg.StormSettings;
import org.elasticsearch.storm.cfg.TupleFailureHandling;
import org.elasticsearch.storm.security.EsClusterInfoSelector;

@Deprecated
public class EsSpout
implements IRichSpout {
    private static transient Log log = LogFactory.getLog(EsSpout.class);
    private final Map spoutConfig = new LinkedHashMap();
    private transient SpoutOutputCollector collector;
    private transient RestService.MultiReaderIterator iterator;
    private final List<String> tupleFields;
    private boolean ackReads = false;
    private int queueSize = 0;
    private Map<Object, Object> inTransitQueue;
    private Queue<Object[]> replayQueue = null;
    private Map<Object, Integer> retries;
    private Integer tupleRetries = -1;
    private TupleFailureHandling tupleFailure = null;

    public EsSpout(String target) {
        this(target, null, null);
    }

    public EsSpout(String target, String query) {
        this(target, query, null);
    }

    public EsSpout(String target, Map configuration) {
        this(target, null, configuration);
    }

    public EsSpout(String target, String query, Map configuration) {
        log.warn((Object)"Support for Apache Storm has been deprecated and will be removed in a future release.");
        if (configuration != null) {
            this.spoutConfig.putAll(configuration);
        }
        if (StringUtils.hasText(query)) {
            this.spoutConfig.put("es.query", query);
        }
        if (StringUtils.hasText(target)) {
            this.spoutConfig.put("es.resource.read", target);
        }
        StormSettings stormSettings = new StormSettings(this.spoutConfig);
        this.tupleFields = stormSettings.getStormSpoutFields();
    }

    public void open(Map conf, TopologyContext context, SpoutOutputCollector collector) {
        this.collector = collector;
        LinkedHashMap copy = new LinkedHashMap(conf);
        copy.putAll(this.spoutConfig);
        StormSettings settings = new StormSettings(copy);
        InitializationUtils.setValueReaderIfNotSet(settings, JdkValueReader.class, log);
        InitializationUtils.setUserProviderIfNotSet(settings, JdkUserProvider.class, log);
        EsClusterInfoSelector.populate(settings);
        this.ackReads = settings.getStormSpoutReliable();
        if (this.ackReads) {
            this.inTransitQueue = new LinkedHashMap<Object, Object>();
            this.replayQueue = new LinkedList<Object[]>();
            this.retries = new HashMap<Object, Integer>();
            this.queueSize = settings.getStormSpoutReliableQueueSize();
            this.tupleRetries = settings.getStormSpoutReliableRetriesPerTuple();
            this.tupleFailure = settings.getStormSpoutReliableTupleFailureHandling();
        }
        int totalTasks = context.getComponentTasks(context.getThisComponentId()).size();
        int currentTask = context.getThisTaskIndex();
        List<PartitionDefinition> partitions = RestService.findPartitions(settings, log);
        List<PartitionDefinition> assigned = RestService.assignPartitions(partitions, currentTask, totalTasks);
        this.iterator = RestService.multiReader(settings, assigned, log);
    }

    public void close() {
        if (this.replayQueue != null) {
            this.replayQueue.clear();
            this.replayQueue = null;
        }
        if (this.retries != null) {
            this.retries.clear();
            this.retries = null;
        }
        if (this.inTransitQueue != null) {
            this.inTransitQueue.clear();
            this.inTransitQueue = null;
        }
        if (this.iterator != null) {
            this.iterator.close();
        }
    }

    public void activate() {
    }

    public void deactivate() {
    }

    public void nextTuple() {
        Object[] next = null;
        if (this.replayQueue != null && !this.replayQueue.isEmpty()) {
            next = this.replayQueue.poll();
        } else if (this.iterator.hasNext()) {
            next = this.iterator.next();
        }
        if (next != null) {
            List<Object> tuple = this.createTuple(next[1]);
            if (this.ackReads) {
                if (this.queueSize > 0) {
                    if (this.inTransitQueue.size() >= this.queueSize) {
                        throw new EsHadoopIllegalStateException(String.format("Ack-tuples queue has exceeded the specified size [%s]", this.inTransitQueue.size()));
                    }
                    this.inTransitQueue.put(next[0], next[1]);
                }
                this.collector.emit(tuple, next[0]);
            } else {
                this.collector.emit(tuple);
            }
        } else {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private List<Object> createTuple(Object value) {
        if (!this.tupleFields.isEmpty()) {
            ArrayList<Object> tuple = new ArrayList<Object>(this.tupleFields.size());
            Map doc = (Map)value;
            for (String field : this.tupleFields) {
                tuple.add(doc.get(field));
            }
            return tuple;
        }
        return Collections.singletonList(value);
    }

    public void ack(Object msgId) {
        this.inTransitQueue.remove(msgId);
        this.retries.remove(msgId);
    }

    public void fail(Object msgId) {
        int primitive;
        Object tuple = this.inTransitQueue.remove(msgId);
        Integer attempts = this.retries.remove(msgId);
        if (attempts == null) {
            attempts = this.tupleRetries;
        }
        if ((primitive = attempts.intValue()) == 0) {
            switch (this.tupleFailure) {
                case ABORT: {
                    throw new EsHadoopIllegalStateException(String.format("Tuple [%s] has failed to be fully processed after [%d] retries; aborting...", tuple, attempts));
                }
                case WARN: {
                    log.warn((Object)String.format("Tuple [%s] has failed to be fully processed after [%d] retries; aborting...", tuple, attempts));
                }
            }
            return;
        }
        if (primitive > 0) {
            --primitive;
        }
        this.retries.put(msgId, primitive);
        this.replayQueue.add(new Object[]{msgId, tuple});
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        Fields fields = this.tupleFields.isEmpty() ? new Fields(new String[]{"doc"}) : new Fields(this.tupleFields);
        declarer.declare(fields);
    }

    public Map<String, Object> getComponentConfiguration() {
        return null;
    }
}

