/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.bulk;

import java.util.Collection;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.serialization.builder.ValueWriter;
import org.elasticsearch.hadoop.serialization.bulk.TemplatedBulk;
import org.elasticsearch.hadoop.serialization.json.JacksonJsonGenerator;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.FastByteArrayOutputStream;

class ScriptTemplateBulk
extends TemplatedBulk {
    private final Settings settings;

    ScriptTemplateBulk(Settings settings, Collection<Object> beforeObject, Collection<Object> afterObject, ValueWriter<?> valueWriter) {
        super(beforeObject, afterObject, valueWriter);
        this.settings = settings;
    }

    @Override
    protected void doWriteObject(Object object, BytesArray storage, ValueWriter<?> writer) {
        if ("upsert".equals(this.settings.getOperation())) {
            if (this.settings.hasScriptUpsert()) {
                FastByteArrayOutputStream bos = new FastByteArrayOutputStream(storage);
                JacksonJsonGenerator generator = new JacksonJsonGenerator(bos);
                generator.writeBeginObject();
                generator.writeEndObject();
                generator.close();
            } else {
                super.doWriteObject(object, storage, writer);
            }
        }
    }
}

