/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.storm.cfg;

import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.util.IOUtils;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.hadoop.util.unit.Booleans;
import org.elasticsearch.storm.cfg.TupleFailureHandling;

public class StormSettings
extends Settings {
    private final Map<Object, Object> cfg;

    public StormSettings(Map<?, ?> settings) {
        this.cfg = new LinkedHashMap(settings);
    }

    public boolean getStormTickTupleFlush() {
        return Booleans.parseBoolean(this.getProperty("es.storm.bolt.tick.tuple.flush", "true"));
    }

    public boolean getStormBoltAck() {
        return Booleans.parseBoolean(this.getProperty("es.storm.bolt.write.ack", "false"));
    }

    public int getStormBulkSize() {
        String value = this.getProperty("es.storm.bolt.flush.entries.size");
        if (StringUtils.hasText(value)) {
            return Integer.valueOf(value);
        }
        return this.getBatchSizeInEntries();
    }

    public boolean getStormSpoutReliable() {
        return Booleans.parseBoolean(this.getProperty("es.storm.spout.reliable", "false"));
    }

    public int getStormSpoutReliableQueueSize() {
        return Integer.parseInt(this.getProperty("es.storm.spout.reliable.queue.size", "0"));
    }

    public int getStormSpoutReliableRetriesPerTuple() {
        return Integer.parseInt(this.getProperty("es.storm.spout.reliable.retries.per.tuple", "5"));
    }

    public TupleFailureHandling getStormSpoutReliableTupleFailureHandling() {
        return TupleFailureHandling.valueOf(this.getProperty("es.storm.spout.reliable.handle.tuple.failure", "abort").toUpperCase(Locale.ENGLISH));
    }

    public List<String> getStormSpoutFields() {
        return StringUtils.tokenize(this.getProperty("es.storm.spout.fields", ""));
    }

    @Override
    public InputStream loadResource(String location) {
        return IOUtils.open(location);
    }

    @Override
    public Settings copy() {
        return new StormSettings(new LinkedHashMap<Object, Object>(this.cfg));
    }

    @Override
    public String getProperty(String name) {
        Object value = this.cfg.get(name);
        return value != null ? value.toString() : null;
    }

    @Override
    public void setProperty(String name, String value) {
        this.cfg.put(name, value);
    }

    @Override
    public Properties asProperties() {
        Properties props = new Properties();
        if (this.cfg != null) {
            for (Map.Entry<Object, Object> entry : this.cfg.entrySet()) {
                if (!(entry.getKey() instanceof String)) continue;
                Object value = entry.getValue();
                if (value == null) {
                    value = "";
                }
                props.put(entry.getKey().toString(), value.toString());
            }
        }
        return props;
    }
}

