/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.yarn.rpc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.elasticsearch.hadoop.yarn.EsYarnException;

public abstract class YarnRpc<P>
implements AutoCloseable {
    private Class<P> protocolType;
    private Configuration cfg;
    private InetSocketAddress endpoint;
    private P proxy;

    public YarnRpc(Class<P> protocolType, Configuration cfg) {
        this.protocolType = protocolType;
        this.cfg = new YarnConfiguration(cfg);
    }

    public void start() {
        if (UserGroupInformation.isSecurityEnabled()) {
            UserGroupInformation.setConfiguration((Configuration)this.cfg);
        }
        try {
            this.endpoint = this.resolveEndpoint(this.cfg);
        }
        catch (IOException ex) {
            throw new EsYarnException("Cannot resolve endpoint", ex);
        }
        UserGroupInformation ugi = null;
        try {
            ugi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ex) {
            throw new EsYarnException("Cannot get current user", ex);
        }
        this.proxy = ugi.doAs(new PrivilegedAction<P>(){

            @Override
            public P run() {
                return YarnRPC.create((Configuration)YarnRpc.this.cfg).getProxy(YarnRpc.this.protocolType, YarnRpc.this.endpoint, YarnRpc.this.cfg);
            }
        });
    }

    protected P proxy() {
        return this.proxy;
    }

    @Override
    public void close() {
        YarnRPC.create((Configuration)this.cfg).stopProxy(this.proxy, this.cfg);
    }

    protected abstract InetSocketAddress resolveEndpoint(Configuration var1) throws IOException;
}

