/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.yarn.compat;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.NMClient;
import org.apache.hadoop.yarn.client.api.NMTokenCache;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.Records;
import org.elasticsearch.hadoop.yarn.util.ReflectionUtils;
import org.elasticsearch.hadoop.yarn.util.YarnUtils;

public abstract class YarnCompat {
    private static String[] DEFAULT_PLATFORM_APPLICATION_CLASSPATH;
    private static String CLASS_PATH_SEPARATOR;
    private static final Method NMCLIENT_SET_TOKEN_CACHE;
    private static final Method AMRMCLIENT_SET_TOKEN_CACHE;
    private static final Method ENVIRONMENT_$$;
    private static final Method SET_VIRTUAL_CORES;
    private static final Method APP_SUBMISSION_CTX;

    public static void setVirtualCores(Configuration cfg, Resource resource, int vCores) {
        if (SET_VIRTUAL_CORES != null) {
            ReflectionUtils.invoke(SET_VIRTUAL_CORES, resource, YarnUtils.minVCores(cfg, vCores));
        }
    }

    public static Resource resource(Configuration cfg, int memory, int cores) {
        Resource resource = (Resource)Records.newRecord(Resource.class);
        resource.setMemory(YarnUtils.minMemory(cfg, memory));
        YarnCompat.setVirtualCores(cfg, resource, cores);
        return resource;
    }

    public static String[] DEFAULT_PLATFORM_APPLICATION_CLASSPATH() {
        if (DEFAULT_PLATFORM_APPLICATION_CLASSPATH == null) {
            Field field = ReflectionUtils.findField(YarnConfiguration.class, "DEFAULT_YARN_CROSS_PLATFORM_APPLICATION_CLASSPATH");
            if (field != null) {
                ReflectionUtils.makeAccessible(field);
                DEFAULT_PLATFORM_APPLICATION_CLASSPATH = (String[])ReflectionUtils.getField(field, null);
            } else {
                DEFAULT_PLATFORM_APPLICATION_CLASSPATH = YarnConfiguration.DEFAULT_YARN_APPLICATION_CLASSPATH;
            }
        }
        return DEFAULT_PLATFORM_APPLICATION_CLASSPATH;
    }

    public static String CLASS_PATH_SEPARATOR() {
        if (CLASS_PATH_SEPARATOR == null) {
            Field field = ReflectionUtils.findField(ApplicationConstants.class, "CLASS_PATH_SEPARATOR");
            if (field != null) {
                ReflectionUtils.makeAccessible(field);
                CLASS_PATH_SEPARATOR = (String)ReflectionUtils.getField(field, null);
            } else {
                CLASS_PATH_SEPARATOR = ":";
            }
        }
        return CLASS_PATH_SEPARATOR;
    }

    public static void setNMTokenCache(AMRMClient<?> client, NMTokenCache tokenCache) {
        if (AMRMCLIENT_SET_TOKEN_CACHE != null) {
            ReflectionUtils.invoke(AMRMCLIENT_SET_TOKEN_CACHE, client, tokenCache);
        }
    }

    public static void setNMTokenCache(NMClient client, NMTokenCache tokenCache) {
        if (NMCLIENT_SET_TOKEN_CACHE != null) {
            ReflectionUtils.invoke(NMCLIENT_SET_TOKEN_CACHE, client, tokenCache);
        }
    }

    public static String $$(ApplicationConstants.Environment env) {
        if (ENVIRONMENT_$$ != null) {
            return (String)ReflectionUtils.invoke(ENVIRONMENT_$$, env, null);
        }
        return "$" + env.name();
    }

    public static void setApplicationTags(ApplicationSubmissionContext appContext, Set<String> appTags) {
        if (APP_SUBMISSION_CTX != null) {
            ReflectionUtils.invoke(APP_SUBMISSION_CTX, appContext, appTags);
        }
    }

    static {
        SET_VIRTUAL_CORES = ReflectionUtils.findMethod(Resource.class, "setVirtualCores", Integer.TYPE);
        NMCLIENT_SET_TOKEN_CACHE = ReflectionUtils.findMethod(NMClient.class, "setNMTokenCache", NMTokenCache.class);
        AMRMCLIENT_SET_TOKEN_CACHE = ReflectionUtils.findMethod(AMRMClient.class, "setNMTokenCache", NMTokenCache.class);
        ENVIRONMENT_$$ = ReflectionUtils.findMethod(ApplicationConstants.Environment.class, "$$", null);
        APP_SUBMISSION_CTX = ReflectionUtils.findMethod(ApplicationSubmissionContext.class, "setApplicationTags", Set.class);
    }
}

