/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.yarn.am;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.NMTokenCache;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.elasticsearch.hadoop.yarn.am.EsYarnAmException;
import org.elasticsearch.hadoop.yarn.compat.YarnCompat;

class AppMasterRpc
implements AutoCloseable {
    private final YarnConfiguration cfg;
    private AMRMClient<AMRMClient.ContainerRequest> client;
    private final NMTokenCache nmTokenCache;

    public AppMasterRpc(Configuration cfg, NMTokenCache nmTokenCache) {
        this.cfg = new YarnConfiguration(cfg);
        this.nmTokenCache = nmTokenCache;
    }

    public void start() {
        if (this.client != null) {
            return;
        }
        this.client = AMRMClient.createAMRMClient();
        YarnCompat.setNMTokenCache(this.client, this.nmTokenCache);
        this.client.init((Configuration)this.cfg);
        this.client.start();
    }

    public RegisterApplicationMasterResponse registerAM() {
        try {
            return this.client.registerApplicationMaster("", 0, "");
        }
        catch (Exception ex) {
            throw new EsYarnAmException(ex);
        }
    }

    public void failAM() {
        this.unregisterAM(FinalApplicationStatus.FAILED);
    }

    public void finishAM() {
        this.unregisterAM(FinalApplicationStatus.SUCCEEDED);
    }

    private void unregisterAM(FinalApplicationStatus status) {
        try {
            this.client.unregisterApplicationMaster(status, "", "");
        }
        catch (Exception ex) {
            throw new EsYarnAmException(ex);
        }
    }

    public void addContainerRequest(AMRMClient.ContainerRequest req) {
        this.client.addContainerRequest(req);
    }

    public AllocateResponse allocate(int step) {
        try {
            return this.client.allocate((float)step);
        }
        catch (Exception ex) {
            throw new EsYarnAmException(ex);
        }
    }

    public Configuration getConfiguration() {
        return this.cfg;
    }

    public NMTokenCache getNMToCache() {
        return this.nmTokenCache;
    }

    @Override
    public void close() {
        if (this.client == null) {
            return;
        }
        this.client.stop();
        this.client = null;
    }
}

