/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.dto;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.elasticsearch.hadoop.util.EsMajorVersion;
import org.elasticsearch.hadoop.util.StringUtils;

public class NodeInfo
implements Serializable {
    private final String id;
    private final String name;
    private final String host;
    private final String ip;
    private final String publishAddress;
    private final boolean hasHttp;
    private final boolean isClient;
    private final boolean isData;
    private final boolean isIngest;

    public NodeInfo(String id, Map<String, Object> map) {
        this.id = id;
        EsMajorVersion version = EsMajorVersion.parse((String)map.get("version"));
        this.name = (String)map.get("name");
        this.host = (String)map.get("host");
        this.ip = (String)map.get("ip");
        if (version.before(EsMajorVersion.V_5_X)) {
            Map attributes = (Map)map.get("attributes");
            if (attributes == null) {
                this.isClient = false;
                this.isData = true;
            } else {
                String data = (String)attributes.get("data");
                this.isClient = data == null ? true : !Boolean.parseBoolean(data);
                this.isData = data == null ? true : Boolean.parseBoolean(data);
            }
            this.isIngest = false;
        } else {
            List roles = (List)map.get("roles");
            this.isClient = !roles.contains("data");
            this.isData = roles.contains("data");
            this.isIngest = roles.contains("ingest");
        }
        Map httpMap = (Map)map.get("http");
        if (httpMap != null) {
            String addr = (String)httpMap.get("publish_address");
            if (addr != null) {
                StringUtils.IpAndPort ipAndPort = StringUtils.parseIpAddress(addr);
                this.publishAddress = ipAndPort.ip + ":" + ipAndPort.port;
                this.hasHttp = true;
            } else {
                this.publishAddress = null;
                this.hasHttp = false;
            }
        } else {
            this.publishAddress = null;
            this.hasHttp = false;
        }
    }

    public boolean hasHttp() {
        return this.hasHttp;
    }

    public boolean isClient() {
        return this.isClient;
    }

    public boolean isData() {
        return this.isData;
    }

    public boolean isIngest() {
        return this.isIngest;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public String getPublishAddress() {
        return this.publishAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeInfo nodeInfo = (NodeInfo)o;
        if (this.hasHttp != nodeInfo.hasHttp) {
            return false;
        }
        if (this.isClient != nodeInfo.isClient) {
            return false;
        }
        if (this.isData != nodeInfo.isData) {
            return false;
        }
        if (!this.id.equals(nodeInfo.id)) {
            return false;
        }
        if (!this.name.equals(nodeInfo.name)) {
            return false;
        }
        if (!this.host.equals(nodeInfo.host)) {
            return false;
        }
        if (!this.ip.equals(nodeInfo.ip)) {
            return false;
        }
        return this.publishAddress != null ? this.publishAddress.equals(nodeInfo.publishAddress) : nodeInfo.publishAddress == null;
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.host.hashCode();
        result = 31 * result + this.ip.hashCode();
        result = 31 * result + (this.publishAddress != null ? this.publishAddress.hashCode() : 0);
        result = 31 * result + (this.hasHttp ? 1 : 0);
        result = 31 * result + (this.isClient ? 1 : 0);
        result = 31 * result + (this.isData ? 1 : 0);
        return result;
    }

    public String toString() {
        return "NodeInfo{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", host='" + this.host + '\'' + ", ip='" + this.ip + '\'' + ", publishAddress='" + this.publishAddress + '\'' + ", hasHttp=" + this.hasHttp + ", isClient=" + this.isClient + ", isData=" + this.isData + '}';
    }
}

