/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public class TemplateRoleName
implements ToXContentObject {
    private static final ConstructingObjectParser<TemplateRoleName, Void> PARSER = new ConstructingObjectParser("template-role-name", true, args -> new TemplateRoleName((String)args[0], (Format)((Object)((Object)args[1]))));
    private final String template;
    private final Format format;

    public TemplateRoleName(String template, Format format) {
        this.template = Objects.requireNonNull(template);
        this.format = Objects.requireNonNull(format);
    }

    public TemplateRoleName(Map<String, Object> template, Format format) throws IOException {
        this(Strings.toString((XContentBuilder)XContentBuilder.builder((XContent)XContentType.JSON.xContent()).map(template)), format);
    }

    public String getTemplate() {
        return this.template;
    }

    public Format getFormat() {
        return this.format;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateRoleName that = (TemplateRoleName)o;
        return Objects.equals(this.template, that.template) && this.format == that.format;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.template, this.format});
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(Fields.TEMPLATE.getPreferredName(), this.template).field(Fields.FORMAT.getPreferredName(), this.format.name().toLowerCase(Locale.ROOT)).endObject();
    }

    static TemplateRoleName fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        return (TemplateRoleName)PARSER.parse(parser, null);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Fields.TEMPLATE);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), x$0 -> Format.fromXContent(x$0), Fields.FORMAT, ObjectParser.ValueType.STRING);
    }

    public static enum Format {
        STRING,
        JSON;


        private static Format fromXContent(XContentParser parser) throws IOException {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_STRING, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            return Format.valueOf(parser.text().toUpperCase(Locale.ROOT));
        }
    }

    public static interface Fields {
        public static final ParseField TEMPLATE = new ParseField("template", new String[0]);
        public static final ParseField FORMAT = new ParseField("format", new String[0]);
    }
}

