/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.dataframe;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.client.ml.dataframe.DataFrameAnalysis;
import org.elasticsearch.client.ml.inference.NamedXContentObjectHelper;
import org.elasticsearch.client.ml.inference.preprocessing.PreProcessor;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class Regression
implements DataFrameAnalysis {
    public static final ParseField NAME = new ParseField("regression", new String[0]);
    static final ParseField DEPENDENT_VARIABLE = new ParseField("dependent_variable", new String[0]);
    static final ParseField LAMBDA = new ParseField("lambda", new String[0]);
    static final ParseField GAMMA = new ParseField("gamma", new String[0]);
    static final ParseField ETA = new ParseField("eta", new String[0]);
    static final ParseField MAX_TREES = new ParseField("max_trees", new String[0]);
    static final ParseField FEATURE_BAG_FRACTION = new ParseField("feature_bag_fraction", new String[0]);
    static final ParseField NUM_TOP_FEATURE_IMPORTANCE_VALUES = new ParseField("num_top_feature_importance_values", new String[0]);
    static final ParseField PREDICTION_FIELD_NAME = new ParseField("prediction_field_name", new String[0]);
    static final ParseField TRAINING_PERCENT = new ParseField("training_percent", new String[0]);
    static final ParseField RANDOMIZE_SEED = new ParseField("randomize_seed", new String[0]);
    static final ParseField LOSS_FUNCTION = new ParseField("loss_function", new String[0]);
    static final ParseField LOSS_FUNCTION_PARAMETER = new ParseField("loss_function_parameter", new String[0]);
    static final ParseField FEATURE_PROCESSORS = new ParseField("feature_processors", new String[0]);
    static final ParseField ALPHA = new ParseField("alpha", new String[0]);
    static final ParseField ETA_GROWTH_RATE_PER_TREE = new ParseField("eta_growth_rate_per_tree", new String[0]);
    static final ParseField SOFT_TREE_DEPTH_LIMIT = new ParseField("soft_tree_depth_limit", new String[0]);
    static final ParseField SOFT_TREE_DEPTH_TOLERANCE = new ParseField("soft_tree_depth_tolerance", new String[0]);
    static final ParseField DOWNSAMPLE_FACTOR = new ParseField("downsample_factor", new String[0]);
    static final ParseField MAX_OPTIMIZATION_ROUNDS_PER_HYPERPARAMETER = new ParseField("max_optimization_rounds_per_hyperparameter", new String[0]);
    static final ParseField EARLY_STOPPING_ENABLED = new ParseField("early_stopping_enabled", new String[0]);
    private static final ConstructingObjectParser<Regression, Void> PARSER = new ConstructingObjectParser(NAME.getPreferredName(), true, a -> new Regression((String)a[0], (Double)a[1], (Double)a[2], (Double)a[3], (Integer)a[4], (Double)a[5], (Integer)a[6], (String)a[7], (Double)a[8], (Long)a[9], (LossFunction)((Object)((Object)a[10])), (Double)a[11], (List)a[12], (Double)a[13], (Double)a[14], (Double)a[15], (Double)a[16], (Double)a[17], (Integer)a[18], (Boolean)a[19]));
    private final String dependentVariable;
    private final Double lambda;
    private final Double gamma;
    private final Double eta;
    private final Integer maxTrees;
    private final Double featureBagFraction;
    private final Integer numTopFeatureImportanceValues;
    private final String predictionFieldName;
    private final Double trainingPercent;
    private final Long randomizeSeed;
    private final LossFunction lossFunction;
    private final Double lossFunctionParameter;
    private final List<PreProcessor> featureProcessors;
    private final Double alpha;
    private final Double etaGrowthRatePerTree;
    private final Double softTreeDepthLimit;
    private final Double softTreeDepthTolerance;
    private final Double downsampleFactor;
    private final Integer maxOptimizationRoundsPerHyperparameter;
    private final Boolean earlyStoppingEnabled;

    public static Regression fromXContent(XContentParser parser) {
        return (Regression)PARSER.apply(parser, null);
    }

    public static Builder builder(String dependentVariable) {
        return new Builder(dependentVariable);
    }

    private Regression(String dependentVariable, @Nullable Double lambda, @Nullable Double gamma, @Nullable Double eta, @Nullable Integer maxTrees, @Nullable Double featureBagFraction, @Nullable Integer numTopFeatureImportanceValues, @Nullable String predictionFieldName, @Nullable Double trainingPercent, @Nullable Long randomizeSeed, @Nullable LossFunction lossFunction, @Nullable Double lossFunctionParameter, @Nullable List<PreProcessor> featureProcessors, @Nullable Double alpha, @Nullable Double etaGrowthRatePerTree, @Nullable Double softTreeDepthLimit, @Nullable Double softTreeDepthTolerance, @Nullable Double downsampleFactor, @Nullable Integer maxOptimizationRoundsPerHyperparameter, @Nullable Boolean earlyStoppingEnabled) {
        this.dependentVariable = Objects.requireNonNull(dependentVariable);
        this.lambda = lambda;
        this.gamma = gamma;
        this.eta = eta;
        this.maxTrees = maxTrees;
        this.featureBagFraction = featureBagFraction;
        this.numTopFeatureImportanceValues = numTopFeatureImportanceValues;
        this.predictionFieldName = predictionFieldName;
        this.trainingPercent = trainingPercent;
        this.randomizeSeed = randomizeSeed;
        this.lossFunction = lossFunction;
        this.lossFunctionParameter = lossFunctionParameter;
        this.featureProcessors = featureProcessors;
        this.alpha = alpha;
        this.etaGrowthRatePerTree = etaGrowthRatePerTree;
        this.softTreeDepthLimit = softTreeDepthLimit;
        this.softTreeDepthTolerance = softTreeDepthTolerance;
        this.downsampleFactor = downsampleFactor;
        this.maxOptimizationRoundsPerHyperparameter = maxOptimizationRoundsPerHyperparameter;
        this.earlyStoppingEnabled = earlyStoppingEnabled;
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    public String getDependentVariable() {
        return this.dependentVariable;
    }

    public Double getLambda() {
        return this.lambda;
    }

    public Double getGamma() {
        return this.gamma;
    }

    public Double getEta() {
        return this.eta;
    }

    public Integer getMaxTrees() {
        return this.maxTrees;
    }

    public Double getFeatureBagFraction() {
        return this.featureBagFraction;
    }

    public Integer getNumTopFeatureImportanceValues() {
        return this.numTopFeatureImportanceValues;
    }

    public String getPredictionFieldName() {
        return this.predictionFieldName;
    }

    public Double getTrainingPercent() {
        return this.trainingPercent;
    }

    public Long getRandomizeSeed() {
        return this.randomizeSeed;
    }

    public LossFunction getLossFunction() {
        return this.lossFunction;
    }

    public Double getLossFunctionParameter() {
        return this.lossFunctionParameter;
    }

    public List<PreProcessor> getFeatureProcessors() {
        return this.featureProcessors;
    }

    public Double getAlpha() {
        return this.alpha;
    }

    public Double getEtaGrowthRatePerTree() {
        return this.etaGrowthRatePerTree;
    }

    public Double getSoftTreeDepthLimit() {
        return this.softTreeDepthLimit;
    }

    public Double getSoftTreeDepthTolerance() {
        return this.softTreeDepthTolerance;
    }

    public Double getDownsampleFactor() {
        return this.downsampleFactor;
    }

    public Integer getMaxOptimizationRoundsPerHyperparameter() {
        return this.maxOptimizationRoundsPerHyperparameter;
    }

    public Boolean getEarlyStoppingEnabled() {
        return this.earlyStoppingEnabled;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DEPENDENT_VARIABLE.getPreferredName(), this.dependentVariable);
        if (this.lambda != null) {
            builder.field(LAMBDA.getPreferredName(), this.lambda);
        }
        if (this.gamma != null) {
            builder.field(GAMMA.getPreferredName(), this.gamma);
        }
        if (this.eta != null) {
            builder.field(ETA.getPreferredName(), this.eta);
        }
        if (this.maxTrees != null) {
            builder.field(MAX_TREES.getPreferredName(), this.maxTrees);
        }
        if (this.featureBagFraction != null) {
            builder.field(FEATURE_BAG_FRACTION.getPreferredName(), this.featureBagFraction);
        }
        if (this.numTopFeatureImportanceValues != null) {
            builder.field(NUM_TOP_FEATURE_IMPORTANCE_VALUES.getPreferredName(), this.numTopFeatureImportanceValues);
        }
        if (this.predictionFieldName != null) {
            builder.field(PREDICTION_FIELD_NAME.getPreferredName(), this.predictionFieldName);
        }
        if (this.trainingPercent != null) {
            builder.field(TRAINING_PERCENT.getPreferredName(), this.trainingPercent);
        }
        if (this.randomizeSeed != null) {
            builder.field(RANDOMIZE_SEED.getPreferredName(), this.randomizeSeed);
        }
        if (this.lossFunction != null) {
            builder.field(LOSS_FUNCTION.getPreferredName(), (Enum)this.lossFunction);
        }
        if (this.lossFunctionParameter != null) {
            builder.field(LOSS_FUNCTION_PARAMETER.getPreferredName(), this.lossFunctionParameter);
        }
        if (this.featureProcessors != null) {
            NamedXContentObjectHelper.writeNamedObjects(builder, params, true, FEATURE_PROCESSORS.getPreferredName(), this.featureProcessors);
        }
        if (this.alpha != null) {
            builder.field(ALPHA.getPreferredName(), this.alpha);
        }
        if (this.etaGrowthRatePerTree != null) {
            builder.field(ETA_GROWTH_RATE_PER_TREE.getPreferredName(), this.etaGrowthRatePerTree);
        }
        if (this.softTreeDepthLimit != null) {
            builder.field(SOFT_TREE_DEPTH_LIMIT.getPreferredName(), this.softTreeDepthLimit);
        }
        if (this.softTreeDepthTolerance != null) {
            builder.field(SOFT_TREE_DEPTH_TOLERANCE.getPreferredName(), this.softTreeDepthTolerance);
        }
        if (this.downsampleFactor != null) {
            builder.field(DOWNSAMPLE_FACTOR.getPreferredName(), this.downsampleFactor);
        }
        if (this.maxOptimizationRoundsPerHyperparameter != null) {
            builder.field(MAX_OPTIMIZATION_ROUNDS_PER_HYPERPARAMETER.getPreferredName(), this.maxOptimizationRoundsPerHyperparameter);
        }
        if (this.earlyStoppingEnabled != null) {
            builder.field(EARLY_STOPPING_ENABLED.getPreferredName(), this.earlyStoppingEnabled);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dependentVariable, this.lambda, this.gamma, this.eta, this.maxTrees, this.featureBagFraction, this.numTopFeatureImportanceValues, this.predictionFieldName, this.trainingPercent, this.randomizeSeed, this.lossFunction, this.lossFunctionParameter, this.featureProcessors, this.alpha, this.etaGrowthRatePerTree, this.softTreeDepthLimit, this.softTreeDepthTolerance, this.downsampleFactor, this.maxOptimizationRoundsPerHyperparameter, this.earlyStoppingEnabled});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Regression that = (Regression)o;
        return Objects.equals(this.dependentVariable, that.dependentVariable) && Objects.equals(this.lambda, that.lambda) && Objects.equals(this.gamma, that.gamma) && Objects.equals(this.eta, that.eta) && Objects.equals(this.maxTrees, that.maxTrees) && Objects.equals(this.featureBagFraction, that.featureBagFraction) && Objects.equals(this.numTopFeatureImportanceValues, that.numTopFeatureImportanceValues) && Objects.equals(this.predictionFieldName, that.predictionFieldName) && Objects.equals(this.trainingPercent, that.trainingPercent) && Objects.equals(this.randomizeSeed, that.randomizeSeed) && Objects.equals((Object)this.lossFunction, (Object)that.lossFunction) && Objects.equals(this.lossFunctionParameter, that.lossFunctionParameter) && Objects.equals(this.featureProcessors, that.featureProcessors) && Objects.equals(this.alpha, that.alpha) && Objects.equals(this.etaGrowthRatePerTree, that.etaGrowthRatePerTree) && Objects.equals(this.softTreeDepthLimit, that.softTreeDepthLimit) && Objects.equals(this.softTreeDepthTolerance, that.softTreeDepthTolerance) && Objects.equals(this.downsampleFactor, that.downsampleFactor) && Objects.equals(this.maxOptimizationRoundsPerHyperparameter, that.maxOptimizationRoundsPerHyperparameter) && Objects.equals(this.earlyStoppingEnabled, that.earlyStoppingEnabled);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), DEPENDENT_VARIABLE);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), LAMBDA);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), GAMMA);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), ETA);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), MAX_TREES);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), FEATURE_BAG_FRACTION);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), NUM_TOP_FEATURE_IMPORTANCE_VALUES);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), PREDICTION_FIELD_NAME);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), TRAINING_PERCENT);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), RANDOMIZE_SEED);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), x$0 -> LossFunction.fromString(x$0), LOSS_FUNCTION);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), LOSS_FUNCTION_PARAMETER);
        PARSER.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> (PreProcessor)p.namedObject(PreProcessor.class, n, c), regression -> {}, FEATURE_PROCESSORS);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), ALPHA);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), ETA_GROWTH_RATE_PER_TREE);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), SOFT_TREE_DEPTH_LIMIT);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), SOFT_TREE_DEPTH_TOLERANCE);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), DOWNSAMPLE_FACTOR);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), MAX_OPTIMIZATION_ROUNDS_PER_HYPERPARAMETER);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), EARLY_STOPPING_ENABLED);
    }

    public static enum LossFunction {
        MSE,
        MSLE,
        HUBER;


        private static LossFunction fromString(String value) {
            return LossFunction.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static class Builder {
        private String dependentVariable;
        private Double lambda;
        private Double gamma;
        private Double eta;
        private Integer maxTrees;
        private Double featureBagFraction;
        private Integer numTopFeatureImportanceValues;
        private String predictionFieldName;
        private Double trainingPercent;
        private Long randomizeSeed;
        private LossFunction lossFunction;
        private Double lossFunctionParameter;
        private List<PreProcessor> featureProcessors;
        private Double alpha;
        private Double etaGrowthRatePerTree;
        private Double softTreeDepthLimit;
        private Double softTreeDepthTolerance;
        private Double downsampleFactor;
        private Integer maxOptimizationRoundsPerHyperparameter;
        private Boolean earlyStoppingEnabled;

        private Builder(String dependentVariable) {
            this.dependentVariable = Objects.requireNonNull(dependentVariable);
        }

        public Builder setLambda(Double lambda) {
            this.lambda = lambda;
            return this;
        }

        public Builder setGamma(Double gamma) {
            this.gamma = gamma;
            return this;
        }

        public Builder setEta(Double eta) {
            this.eta = eta;
            return this;
        }

        public Builder setMaxTrees(Integer maxTrees) {
            this.maxTrees = maxTrees;
            return this;
        }

        public Builder setFeatureBagFraction(Double featureBagFraction) {
            this.featureBagFraction = featureBagFraction;
            return this;
        }

        public Builder setNumTopFeatureImportanceValues(Integer numTopFeatureImportanceValues) {
            this.numTopFeatureImportanceValues = numTopFeatureImportanceValues;
            return this;
        }

        public Builder setPredictionFieldName(String predictionFieldName) {
            this.predictionFieldName = predictionFieldName;
            return this;
        }

        public Builder setTrainingPercent(Double trainingPercent) {
            this.trainingPercent = trainingPercent;
            return this;
        }

        public Builder setRandomizeSeed(Long randomizeSeed) {
            this.randomizeSeed = randomizeSeed;
            return this;
        }

        public Builder setLossFunction(LossFunction lossFunction) {
            this.lossFunction = lossFunction;
            return this;
        }

        public Builder setLossFunctionParameter(Double lossFunctionParameter) {
            this.lossFunctionParameter = lossFunctionParameter;
            return this;
        }

        public Builder setFeatureProcessors(List<PreProcessor> featureProcessors) {
            this.featureProcessors = featureProcessors;
            return this;
        }

        public Builder setAlpha(Double alpha) {
            this.alpha = alpha;
            return this;
        }

        public Builder setEtaGrowthRatePerTree(Double etaGrowthRatePerTree) {
            this.etaGrowthRatePerTree = etaGrowthRatePerTree;
            return this;
        }

        public Builder setSoftTreeDepthLimit(Double softTreeDepthLimit) {
            this.softTreeDepthLimit = softTreeDepthLimit;
            return this;
        }

        public Builder setSoftTreeDepthTolerance(Double softTreeDepthTolerance) {
            this.softTreeDepthTolerance = softTreeDepthTolerance;
            return this;
        }

        public Builder setDownsampleFactor(Double downsampleFactor) {
            this.downsampleFactor = downsampleFactor;
            return this;
        }

        public Builder setMaxOptimizationRoundsPerHyperparameter(Integer maxOptimizationRoundsPerHyperparameter) {
            this.maxOptimizationRoundsPerHyperparameter = maxOptimizationRoundsPerHyperparameter;
            return this;
        }

        public Builder setEarlyStoppingEnabled(Boolean earlyStoppingEnabled) {
            this.earlyStoppingEnabled = earlyStoppingEnabled;
            return this;
        }

        public Regression build() {
            return new Regression(this.dependentVariable, this.lambda, this.gamma, this.eta, this.maxTrees, this.featureBagFraction, this.numTopFeatureImportanceValues, this.predictionFieldName, this.trainingPercent, this.randomizeSeed, this.lossFunction, this.lossFunctionParameter, this.featureProcessors, this.alpha, this.etaGrowthRatePerTree, this.softTreeDepthLimit, this.softTreeDepthTolerance, this.downsampleFactor, this.maxOptimizationRoundsPerHyperparameter, this.earlyStoppingEnabled);
        }
    }
}

