/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security.user.privileges;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.client.security.user.privileges.GlobalOperationPrivilege;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class GlobalPrivileges
implements ToXContentObject {
    public static final List<String> CATEGORIES = Collections.singletonList("application");
    static final ConstructingObjectParser<GlobalPrivileges, Void> PARSER = new ConstructingObjectParser("global_category_privileges", false, constructorObjects -> new GlobalPrivileges((Collection)constructorObjects[0]));
    private final Set<? extends GlobalOperationPrivilege> privileges;
    private final Map<String, List<GlobalOperationPrivilege>> privilegesByCategoryMap;

    public GlobalPrivileges(Collection<? extends GlobalOperationPrivilege> privileges) {
        if (privileges == null || privileges.isEmpty()) {
            throw new IllegalArgumentException("Privileges cannot be empty or null");
        }
        this.privileges = Collections.unmodifiableSet(new HashSet<GlobalOperationPrivilege>(Objects.requireNonNull(privileges)));
        this.privilegesByCategoryMap = Collections.unmodifiableMap(this.privileges.stream().collect(Collectors.groupingBy(GlobalOperationPrivilege::getCategory)));
        for (Map.Entry<String, List<GlobalOperationPrivilege>> privilegesByCategory : this.privilegesByCategoryMap.entrySet()) {
            Set allOperations = privilegesByCategory.getValue().stream().map(p -> p.getOperation()).collect(Collectors.toSet());
            if (allOperations.size() == privilegesByCategory.getValue().size()) continue;
            throw new IllegalArgumentException("Different privileges for the same category and operation are not permitted");
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (Map.Entry<String, List<GlobalOperationPrivilege>> privilegesByCategory : this.privilegesByCategoryMap.entrySet()) {
            builder.startObject(privilegesByCategory.getKey());
            for (GlobalOperationPrivilege privilege : privilegesByCategory.getValue()) {
                builder.field(privilege.getOperation(), privilege.getRaw());
            }
            builder.endObject();
        }
        return builder.endObject();
    }

    public static GlobalPrivileges fromXContent(XContentParser parser) {
        return (GlobalPrivileges)PARSER.apply(parser, null);
    }

    public Set<? extends GlobalOperationPrivilege> getPrivileges() {
        return this.privileges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalPrivileges that = (GlobalPrivileges)o;
        return this.privileges.equals(that.privileges);
    }

    public int hashCode() {
        return Objects.hash(this.privileges);
    }

    static {
        for (String category : CATEGORIES) {
            PARSER.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), (parser, context, operation) -> GlobalOperationPrivilege.fromXContent(category, operation, parser), new ParseField(category, new String[0]));
        }
    }
}

