/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.util.Objects;
import org.elasticsearch.client.Validatable;

public final class GetServiceAccountCredentialsRequest
implements Validatable {
    private final String namespace;
    private final String serviceName;

    public GetServiceAccountCredentialsRequest(String namespace, String serviceName) {
        this.namespace = Objects.requireNonNull(namespace, "namespace is required");
        this.serviceName = Objects.requireNonNull(serviceName, "service-name is required");
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetServiceAccountCredentialsRequest that = (GetServiceAccountCredentialsRequest)o;
        return this.namespace.equals(that.namespace) && this.serviceName.equals(that.serviceName);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.serviceName);
    }
}

