/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class AbstractResultResponse<T extends ToXContent>
implements ToXContentObject {
    public static final ParseField COUNT = new ParseField("count", new String[0]);
    private final ParseField resultsField;
    protected final List<T> results;
    protected final long count;

    AbstractResultResponse(ParseField resultsField, List<T> results, long count) {
        this.resultsField = Objects.requireNonNull(resultsField, "[results_field] must not be null");
        this.results = Collections.unmodifiableList(results);
        this.count = count;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(COUNT.getPreferredName(), this.count);
        builder.field(this.resultsField.getPreferredName(), this.results);
        builder.endObject();
        return builder;
    }

    public long count() {
        return this.count;
    }
}

