/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.client.security.support.ApiKey;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;

public final class QueryApiKeyResponse {
    private final long total;
    private final List<ApiKey> apiKeys;
    static final ConstructingObjectParser<QueryApiKeyResponse, Void> PARSER = new ConstructingObjectParser("query_api_key_response", args -> {
        List items;
        long total = (Long)args[0];
        int count = (Integer)args[1];
        if (count != (items = (List)args[2]).size()) {
            throw new IllegalArgumentException("count [" + count + "] is not equal to number of items [" + items.size() + "]");
        }
        return new QueryApiKeyResponse(total, items);
    });

    public QueryApiKeyResponse(long total, List<ApiKey> apiKeys) {
        this.total = total;
        this.apiKeys = apiKeys;
    }

    public long getTotal() {
        return this.total;
    }

    public int getCount() {
        return this.apiKeys.size();
    }

    public List<ApiKey> getApiKeys() {
        return this.apiKeys;
    }

    public static QueryApiKeyResponse fromXContent(XContentParser parser) throws IOException {
        return (QueryApiKeyResponse)PARSER.parse(parser, null);
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("total", new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField("count", new String[0]));
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ApiKey.fromXContent(p), new ParseField("api_keys", new String[0]));
    }
}

