/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ccr;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;

public final class PutFollowResponse {
    static final ParseField FOLLOW_INDEX_CREATED = new ParseField("follow_index_created", new String[0]);
    static final ParseField FOLLOW_INDEX_SHARDS_ACKED = new ParseField("follow_index_shards_acked", new String[0]);
    static final ParseField INDEX_FOLLOWING_STARTED = new ParseField("index_following_started", new String[0]);
    private static final ConstructingObjectParser<PutFollowResponse, Void> PARSER = new ConstructingObjectParser("put_follow_response", true, args -> new PutFollowResponse((Boolean)args[0], (Boolean)args[1], (Boolean)args[2]));
    private final boolean followIndexCreated;
    private final boolean followIndexShardsAcked;
    private final boolean indexFollowingStarted;

    public static PutFollowResponse fromXContent(XContentParser parser) throws IOException {
        return (PutFollowResponse)PARSER.parse(parser, null);
    }

    public PutFollowResponse(boolean followIndexCreated, boolean followIndexShardsAcked, boolean indexFollowingStarted) {
        this.followIndexCreated = followIndexCreated;
        this.followIndexShardsAcked = followIndexShardsAcked;
        this.indexFollowingStarted = indexFollowingStarted;
    }

    public boolean isFollowIndexCreated() {
        return this.followIndexCreated;
    }

    public boolean isFollowIndexShardsAcked() {
        return this.followIndexShardsAcked;
    }

    public boolean isIndexFollowingStarted() {
        return this.indexFollowingStarted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutFollowResponse that = (PutFollowResponse)o;
        return this.followIndexCreated == that.followIndexCreated && this.followIndexShardsAcked == that.followIndexShardsAcked && this.indexFollowingStarted == that.indexFollowingStarted;
    }

    public int hashCode() {
        return Objects.hash(this.followIndexCreated, this.followIndexShardsAcked, this.indexFollowingStarted);
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), FOLLOW_INDEX_CREATED);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), FOLLOW_INDEX_SHARDS_ACKED);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), INDEX_FOLLOWING_STARTED);
    }
}

