/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.IOException;
import java.util.Collections;
import org.apache.http.Header;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheRequest;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheResponse;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequest;
import org.elasticsearch.action.admin.indices.close.CloseIndexResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.flush.FlushResponse;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeResponse;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.elasticsearch.action.admin.indices.open.OpenIndexResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverResponse;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsResponse;
import org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RestHighLevelClient;

public final class IndicesClient {
    private final RestHighLevelClient restHighLevelClient;

    IndicesClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public DeleteIndexResponse delete(DeleteIndexRequest deleteIndexRequest, Header ... headers) throws IOException {
        return (DeleteIndexResponse)this.restHighLevelClient.performRequestAndParseEntity(deleteIndexRequest, Request::deleteIndex, DeleteIndexResponse::fromXContent, Collections.emptySet(), headers);
    }

    public void deleteAsync(DeleteIndexRequest deleteIndexRequest, ActionListener<DeleteIndexResponse> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(deleteIndexRequest, Request::deleteIndex, DeleteIndexResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public CreateIndexResponse create(CreateIndexRequest createIndexRequest, Header ... headers) throws IOException {
        return (CreateIndexResponse)this.restHighLevelClient.performRequestAndParseEntity(createIndexRequest, Request::createIndex, CreateIndexResponse::fromXContent, Collections.emptySet(), headers);
    }

    public void createAsync(CreateIndexRequest createIndexRequest, ActionListener<CreateIndexResponse> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(createIndexRequest, Request::createIndex, CreateIndexResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public PutMappingResponse putMapping(PutMappingRequest putMappingRequest, Header ... headers) throws IOException {
        return (PutMappingResponse)this.restHighLevelClient.performRequestAndParseEntity(putMappingRequest, Request::putMapping, PutMappingResponse::fromXContent, Collections.emptySet(), headers);
    }

    public void putMappingAsync(PutMappingRequest putMappingRequest, ActionListener<PutMappingResponse> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(putMappingRequest, Request::putMapping, PutMappingResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public IndicesAliasesResponse updateAliases(IndicesAliasesRequest indicesAliasesRequest, Header ... headers) throws IOException {
        return (IndicesAliasesResponse)this.restHighLevelClient.performRequestAndParseEntity(indicesAliasesRequest, Request::updateAliases, IndicesAliasesResponse::fromXContent, Collections.emptySet(), headers);
    }

    public void updateAliasesAsync(IndicesAliasesRequest indicesAliasesRequest, ActionListener<IndicesAliasesResponse> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(indicesAliasesRequest, Request::updateAliases, IndicesAliasesResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public OpenIndexResponse open(OpenIndexRequest openIndexRequest, Header ... headers) throws IOException {
        return (OpenIndexResponse)this.restHighLevelClient.performRequestAndParseEntity(openIndexRequest, Request::openIndex, OpenIndexResponse::fromXContent, Collections.emptySet(), headers);
    }

    public void openAsync(OpenIndexRequest openIndexRequest, ActionListener<OpenIndexResponse> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(openIndexRequest, Request::openIndex, OpenIndexResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public CloseIndexResponse close(CloseIndexRequest closeIndexRequest, Header ... headers) throws IOException {
        return (CloseIndexResponse)this.restHighLevelClient.performRequestAndParseEntity(closeIndexRequest, Request::closeIndex, CloseIndexResponse::fromXContent, Collections.emptySet(), headers);
    }

    public void closeAsync(CloseIndexRequest closeIndexRequest, ActionListener<CloseIndexResponse> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(closeIndexRequest, Request::closeIndex, CloseIndexResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public boolean existsAlias(GetAliasesRequest getAliasesRequest, Header ... headers) throws IOException {
        return (Boolean)this.restHighLevelClient.performRequest(getAliasesRequest, Request::existsAlias, RestHighLevelClient::convertExistsResponse, Collections.emptySet(), headers);
    }

    public void existsAliasAsync(GetAliasesRequest getAliasesRequest, ActionListener<Boolean> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsync(getAliasesRequest, Request::existsAlias, RestHighLevelClient::convertExistsResponse, listener, Collections.emptySet(), headers);
    }

    public RefreshResponse refresh(RefreshRequest refreshRequest, Header ... headers) throws IOException {
        return (RefreshResponse)this.restHighLevelClient.performRequestAndParseEntity(refreshRequest, Request::refresh, RefreshResponse::fromXContent, Collections.emptySet(), headers);
    }

    public void refreshAsync(RefreshRequest refreshRequest, ActionListener<RefreshResponse> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(refreshRequest, Request::refresh, RefreshResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public FlushResponse flush(FlushRequest flushRequest, Header ... headers) throws IOException {
        return (FlushResponse)this.restHighLevelClient.performRequestAndParseEntity(flushRequest, Request::flush, FlushResponse::fromXContent, Collections.emptySet(), headers);
    }

    public void flushAsync(FlushRequest flushRequest, ActionListener<FlushResponse> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(flushRequest, Request::flush, FlushResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public ForceMergeResponse forceMerge(ForceMergeRequest forceMergeRequest, Header ... headers) throws IOException {
        return (ForceMergeResponse)this.restHighLevelClient.performRequestAndParseEntity(forceMergeRequest, Request::forceMerge, ForceMergeResponse::fromXContent, Collections.emptySet(), headers);
    }

    public void forceMergeAsync(ForceMergeRequest forceMergeRequest, ActionListener<ForceMergeResponse> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(forceMergeRequest, Request::forceMerge, ForceMergeResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public ClearIndicesCacheResponse clearCache(ClearIndicesCacheRequest clearIndicesCacheRequest, Header ... headers) throws IOException {
        return (ClearIndicesCacheResponse)this.restHighLevelClient.performRequestAndParseEntity(clearIndicesCacheRequest, Request::clearCache, ClearIndicesCacheResponse::fromXContent, Collections.emptySet(), headers);
    }

    public void clearCacheAsync(ClearIndicesCacheRequest clearIndicesCacheRequest, ActionListener<ClearIndicesCacheResponse> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(clearIndicesCacheRequest, Request::clearCache, ClearIndicesCacheResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public boolean exists(GetIndexRequest request, Header ... headers) throws IOException {
        return (Boolean)this.restHighLevelClient.performRequest(request, Request::indicesExist, RestHighLevelClient::convertExistsResponse, Collections.emptySet(), headers);
    }

    public void existsAsync(GetIndexRequest request, ActionListener<Boolean> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsync(request, Request::indicesExist, RestHighLevelClient::convertExistsResponse, listener, Collections.emptySet(), headers);
    }

    public ResizeResponse shrink(ResizeRequest resizeRequest, Header ... headers) throws IOException {
        return (ResizeResponse)this.restHighLevelClient.performRequestAndParseEntity(resizeRequest, Request::shrink, ResizeResponse::fromXContent, Collections.emptySet(), headers);
    }

    public void shrinkAsync(ResizeRequest resizeRequest, ActionListener<ResizeResponse> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(resizeRequest, Request::shrink, ResizeResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public ResizeResponse split(ResizeRequest resizeRequest, Header ... headers) throws IOException {
        return (ResizeResponse)this.restHighLevelClient.performRequestAndParseEntity(resizeRequest, Request::split, ResizeResponse::fromXContent, Collections.emptySet(), headers);
    }

    public void splitAsync(ResizeRequest resizeRequest, ActionListener<ResizeResponse> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(resizeRequest, Request::split, ResizeResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public RolloverResponse rollover(RolloverRequest rolloverRequest, Header ... headers) throws IOException {
        return (RolloverResponse)this.restHighLevelClient.performRequestAndParseEntity(rolloverRequest, Request::rollover, RolloverResponse::fromXContent, Collections.emptySet(), headers);
    }

    public void rolloverAsync(RolloverRequest rolloverRequest, ActionListener<RolloverResponse> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(rolloverRequest, Request::rollover, RolloverResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public UpdateSettingsResponse putSettings(UpdateSettingsRequest updateSettingsRequest, Header ... headers) throws IOException {
        return (UpdateSettingsResponse)this.restHighLevelClient.performRequestAndParseEntity(updateSettingsRequest, Request::indexPutSettings, UpdateSettingsResponse::fromXContent, Collections.emptySet(), headers);
    }

    public void putSettingsAsync(UpdateSettingsRequest updateSettingsRequest, ActionListener<UpdateSettingsResponse> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(updateSettingsRequest, Request::indexPutSettings, UpdateSettingsResponse::fromXContent, listener, Collections.emptySet(), headers);
    }
}

