/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jcache;

import javax.cache.Cache;
import net.sf.ehcache.Element;

public class JCacheEntry<K, V>
implements Cache.Entry<K, V> {
    private final Element element;
    private final Class<K> keyType;
    private final Class<V> valueType;

    public JCacheEntry(Element e, Class<K> keyType, Class<V> valueType) {
        this.element = e;
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public K getKey() {
        if (this.element != null) {
            return this.keyType.cast(this.element.getObjectKey());
        }
        return null;
    }

    public V getValue() {
        if (this.element != null) {
            return this.valueType.cast(this.element.getObjectValue());
        }
        return null;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        if (clazz.isAssignableFrom(Element.class)) {
            return clazz.cast(this.element);
        }
        throw new IllegalArgumentException();
    }
}

