/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jcache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.compound.ReadWriteCopyStrategy;

class JCacheCopyOnWriteStrategy
implements ReadWriteCopyStrategy<Element> {
    JCacheCopyOnWriteStrategy() {
    }

    public Element copyForWrite(Element value, ClassLoader classLoader) {
        if (value == null) {
            return null;
        }
        Object elementValue = value.getObjectValue();
        Object elementKey = value.getObjectKey();
        Object newKey = this.toObject(this.toByteArray(elementKey), classLoader);
        Object serializedValue = this.toObject(this.toByteArray(elementValue), classLoader);
        return this.duplicateElementWithNewValue(value, newKey, serializedValue);
    }

    byte[] toByteArray(Object elementValue) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(bout);
            oos.writeObject(elementValue);
        }
        catch (Exception e) {
            throw new CacheException("When configured copyOnRead or copyOnWrite, a Store will only accept Serializable values", (Throwable)e);
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (Exception e) {}
        }
        return bout.toByteArray();
    }

    public Element copyForRead(Element storedValue, ClassLoader classLoader) {
        if (storedValue == null) {
            return null;
        }
        Object newKey = this.toObject(this.toByteArray(storedValue.getObjectKey()), classLoader);
        Object deserializedValue = this.toObject(this.toByteArray(storedValue.getObjectValue()), classLoader);
        return this.duplicateElementWithNewValue(storedValue, newKey, deserializedValue);
    }

    Object toObject(byte[] bytes, ClassLoader loader) {
        Object deserializedElement;
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
        PreferredClassLoaderObjectInputSteam ois = null;
        try {
            ois = new PreferredClassLoaderObjectInputSteam(bin, loader);
            deserializedElement = ois.readObject();
        }
        catch (Exception e) {
            throw new CacheException("When configured copyOnRead or copyOnWrite, a Store will only accept Serializable values", (Throwable)e);
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (Exception e) {}
        }
        return deserializedElement;
    }

    Element duplicateElementWithNewValue(Element element, Object newKey, Object newValue) {
        return new Element(newKey, newValue, element.getVersion(), element.getCreationTime(), element.getLastAccessTime(), element.getHitCount(), element.usesCacheDefaultLifespan(), element.getTimeToLive(), element.getTimeToIdle(), element.getLastUpdateTime());
    }

    private static class PreferredClassLoaderObjectInputSteam
    extends ObjectInputStream {
        private ClassLoader classLoader;

        public PreferredClassLoaderObjectInputSteam(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classLoader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            return Class.forName(desc.getName(), false, this.classLoader);
        }
    }
}

