/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jcache;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.expiry.Duration;
import javax.cache.expiry.EternalExpiryPolicy;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;
import net.sf.ehcache.config.CacheConfiguration;
import org.ehcache.jcache.JCacheListenerAdapter;

public class JCacheConfiguration<K, V>
implements CompleteConfiguration<K, V> {
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final ExpiryPolicy expiryPolicy;
    private final ConcurrentMap<CacheEntryListenerConfiguration<K, V>, JCacheListenerAdapter<K, V>> cacheEntryListenerConfigurations = new ConcurrentHashMap<CacheEntryListenerConfiguration<K, V>, JCacheListenerAdapter<K, V>>();
    private final boolean storeByValue;
    private final boolean readThrough;
    private final boolean writeThrough;
    private final Factory<CacheLoader<K, V>> cacheLoaderFactory;
    private final Factory<CacheWriter<? super K, ? super V>> cacheWristerFactory;
    private final Factory<ExpiryPolicy> expiryPolicyFactory;
    private final Set<CacheEntryListenerConfiguration<K, V>> initialCacheEntryListenerConfigurations;
    private boolean statisticsEnabled;
    private boolean managementEnabled;

    public JCacheConfiguration(final CacheConfiguration cacheConfiguration, Configuration<K, V> configuration, Class<K> keyType, Class<V> valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
        if (configuration instanceof CompleteConfiguration) {
            CompleteConfiguration cConfiguration = (CompleteConfiguration)configuration;
            Factory expiryPolicyFactory = cConfiguration.getExpiryPolicyFactory();
            this.expiryPolicy = (ExpiryPolicy)expiryPolicyFactory.create();
            this.storeByValue = configuration.isStoreByValue();
            this.readThrough = cConfiguration.isReadThrough();
            this.writeThrough = cConfiguration.isWriteThrough();
            this.statisticsEnabled = cConfiguration.isStatisticsEnabled();
            this.managementEnabled = cConfiguration.isManagementEnabled();
            this.cacheLoaderFactory = cConfiguration.getCacheLoaderFactory();
            this.cacheWristerFactory = cConfiguration.getCacheWriterFactory();
            this.expiryPolicyFactory = cConfiguration.getExpiryPolicyFactory();
            HashSet<CacheEntryListenerConfiguration> set = new HashSet<CacheEntryListenerConfiguration>();
            for (CacheEntryListenerConfiguration kvCacheEntryListenerConfiguration : cConfiguration.getCacheEntryListenerConfigurations()) {
                set.add(kvCacheEntryListenerConfiguration);
            }
            this.initialCacheEntryListenerConfigurations = Collections.unmodifiableSet(set);
        } else if (cacheConfiguration == null) {
            this.expiryPolicyFactory = EternalExpiryPolicy.factoryOf();
            this.expiryPolicy = (ExpiryPolicy)this.expiryPolicyFactory.create();
            this.storeByValue = true;
            this.readThrough = false;
            this.writeThrough = false;
            this.cacheLoaderFactory = null;
            this.cacheWristerFactory = null;
            this.initialCacheEntryListenerConfigurations = new HashSet<CacheEntryListenerConfiguration<K, V>>();
        } else {
            this.expiryPolicyFactory = null;
            this.expiryPolicy = new ExpiryPolicy(){

                public Duration getExpiryForCreation() {
                    return new Duration(TimeUnit.SECONDS, cacheConfiguration.getTimeToLiveSeconds());
                }

                public Duration getExpiryForAccess() {
                    return new Duration(TimeUnit.SECONDS, cacheConfiguration.getTimeToLiveSeconds());
                }

                public Duration getExpiryForUpdate() {
                    return this.getExpiryForCreation();
                }
            };
            this.storeByValue = false;
            this.readThrough = false;
            this.writeThrough = false;
            this.cacheLoaderFactory = null;
            this.cacheWristerFactory = null;
            this.initialCacheEntryListenerConfigurations = new HashSet<CacheEntryListenerConfiguration<K, V>>();
        }
    }

    public JCacheConfiguration(CacheConfiguration cacheConfiguration) {
        this(cacheConfiguration, null, null, null);
    }

    public JCacheConfiguration(Configuration<K, V> configuration) {
        this(null, configuration, configuration.getKeyType(), configuration.getValueType());
    }

    public Class<K> getKeyType() {
        return this.keyType == null ? Object.class : this.keyType;
    }

    public Class<V> getValueType() {
        return this.valueType == null ? Object.class : this.valueType;
    }

    public boolean isStoreByValue() {
        return this.storeByValue;
    }

    public boolean isReadThrough() {
        return this.readThrough;
    }

    public boolean isWriteThrough() {
        return this.writeThrough;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public boolean isManagementEnabled() {
        return this.managementEnabled;
    }

    public Iterable<CacheEntryListenerConfiguration<K, V>> getCacheEntryListenerConfigurations() {
        return this.cacheEntryListenerConfigurations.keySet();
    }

    public Factory<CacheLoader<K, V>> getCacheLoaderFactory() {
        return this.cacheLoaderFactory;
    }

    public Factory<CacheWriter<? super K, ? super V>> getCacheWriterFactory() {
        return this.cacheWristerFactory;
    }

    public Factory<ExpiryPolicy> getExpiryPolicyFactory() {
        return this.expiryPolicyFactory;
    }

    public ExpiryPolicy getExpiryPolicy() {
        return this.expiryPolicy;
    }

    public boolean addCacheEntryListenerConfiguration(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration, JCacheListenerAdapter<K, V> cacheEventListener) {
        return this.cacheEntryListenerConfigurations.putIfAbsent(cacheEntryListenerConfiguration, cacheEventListener) == null;
    }

    public JCacheListenerAdapter<K, V> removeCacheEntryListenerConfiguration(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        return (JCacheListenerAdapter)this.cacheEntryListenerConfigurations.remove(cacheEntryListenerConfiguration);
    }

    void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    void setManagementEnabled(boolean managementEnabled) {
        this.managementEnabled = managementEnabled;
    }

    public Iterable<CacheEntryListenerConfiguration<K, V>> getInitialCacheEntryListenerConfigurations() {
        return this.initialCacheEntryListenerConfigurations;
    }

    public boolean overrideDefaultExpiry() {
        return this.expiryPolicyFactory != null;
    }
}

