/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.transactions.xa.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.time.TimeSource;
import org.ehcache.transactions.xa.internal.SoftLock;
import org.ehcache.transactions.xa.internal.TransactionId;
import org.ehcache.transactions.xa.internal.XATransactionContext;
import org.ehcache.transactions.xa.internal.XAValueHolder;
import org.ehcache.transactions.xa.internal.journal.Journal;

public class XATransactionContextFactory<K, V> {
    private final Map<TransactionId, XATransactionContext<K, V>> transactionContextMap = new ConcurrentHashMap<TransactionId, XATransactionContext<K, V>>();
    private final TimeSource timeSource;

    public XATransactionContextFactory(TimeSource timeSource) {
        this.timeSource = timeSource;
    }

    public XATransactionContext<K, V> createTransactionContext(TransactionId transactionId, Store<K, SoftLock<V>> underlyingStore, Journal<K> journal, int transactionTimeoutInSeconds) {
        long nowTimestamp = this.timeSource.getTimeMillis();
        long timeoutTimestamp = nowTimestamp + TimeUnit.SECONDS.toMillis(transactionTimeoutInSeconds);
        XATransactionContext<K, V> transactionContext = new XATransactionContext<K, V>(transactionId, underlyingStore, journal, this.timeSource, timeoutTimestamp);
        this.transactionContextMap.put(transactionId, transactionContext);
        return transactionContext;
    }

    public XATransactionContext<K, V> get(TransactionId transactionId) {
        return this.transactionContextMap.get(transactionId);
    }

    public void destroy(TransactionId transactionId) {
        this.transactionContextMap.remove(transactionId);
    }

    public boolean contains(TransactionId transactionId) {
        return this.transactionContextMap.containsKey(transactionId);
    }

    public Map<K, XAValueHolder<V>> listPuts(TransactionId transactionId) {
        XATransactionContext<K, V> transactionContext = this.transactionContextMap.get(transactionId);
        if (transactionContext == null) {
            throw new IllegalStateException("Cannot check for removed key outside of transactional context");
        }
        return transactionContext.newValueHolders();
    }

    public boolean isTouched(TransactionId transactionId, K key) {
        XATransactionContext<K, V> transactionContext = this.transactionContextMap.get(transactionId);
        if (transactionContext == null) {
            throw new IllegalStateException("Cannot check for removed key outside of transactional context");
        }
        return transactionContext.touched(key);
    }
}

