/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.model;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.json.bind.JsonbException;
import javax.json.bind.config.PropertyVisibilityStrategy;
import org.eclipse.yasson.internal.model.GetValueCommand;
import org.eclipse.yasson.internal.model.Property;
import org.eclipse.yasson.internal.model.PropertyValuePropagation;
import org.eclipse.yasson.internal.model.SetValueCommand;

public class ReflectionPropagation
extends PropertyValuePropagation {
    private GetValueCommand getValueCommand;
    private SetValueCommand setValueCommand;

    public ReflectionPropagation(Property property, PropertyVisibilityStrategy strategy) {
        super(property, strategy);
    }

    @Override
    protected void acceptMethod(Method method, PropertyValuePropagation.OperationMode mode) {
        Objects.requireNonNull(method);
        switch (mode) {
            case GET: {
                this.getValueCommand = x$0 -> method.invoke(x$0, new Object[0]);
                break;
            }
            case SET: {
                this.setValueCommand = (x$0, xva$1) -> method.invoke(x$0, xva$1);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown mode");
            }
        }
    }

    @Override
    protected void acceptField(Field field, PropertyValuePropagation.OperationMode mode) {
        Objects.requireNonNull(field);
        switch (mode) {
            case GET: {
                this.getValueCommand = field::get;
                break;
            }
            case SET: {
                this.setValueCommand = field::set;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown mode");
            }
        }
    }

    @Override
    void setValue(Object object, Object value) {
        Objects.requireNonNull(object);
        try {
            this.setValueCommand.setValue(object, value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new JsonbException("Error getting value on: " + object, (Throwable)e);
        }
    }

    @Override
    Object getValue(Object object) {
        Objects.requireNonNull(object);
        try {
            return this.getValueCommand.getValue(object);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new JsonbException("Error getting value on: " + object, (Throwable)e);
        }
    }
}

