/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import org.eclipse.yasson.internal.model.customization.Customization;
import org.eclipse.yasson.internal.serializer.AbstractDateTimeDeserializer;

public class SqlTimestampTypeDeserializer
extends AbstractDateTimeDeserializer<Timestamp> {
    private static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ISO_DATE_TIME.withZone(UTC);

    public SqlTimestampTypeDeserializer(Customization customization) {
        super(Timestamp.class, customization);
    }

    public SqlTimestampTypeDeserializer() {
        super(Timestamp.class, null);
    }

    @Override
    protected Timestamp fromInstant(Instant instant) {
        return Timestamp.from(instant);
    }

    @Override
    protected Timestamp parseDefault(String jsonValue, Locale locale) {
        TemporalAccessor parsed = DEFAULT_FORMATTER.withLocale(locale).parse(jsonValue);
        return Timestamp.from(this.getInstant(parsed));
    }

    @Override
    protected Timestamp parseWithFormatter(String jsonValue, DateTimeFormatter formatter) {
        TemporalAccessor parsed = this.getZonedFormatter(formatter).parse(jsonValue);
        return Timestamp.from(this.getInstant(parsed));
    }

    private Instant getInstant(TemporalAccessor parsed) {
        LocalDateTime local = LocalDateTime.from(parsed);
        return local.atZone(ZoneId.of("UTC")).toInstant();
    }
}

